/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.filemanagement.json.actions;

import com.openexchange.ajax.SessionServlet;
import com.openexchange.ajax.container.FileHolder;
import com.openexchange.ajax.requesthandler.AJAXActionService;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.requesthandler.DispatcherNotes;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.filemanagement.ManagedFile;
import com.openexchange.filemanagement.ManagedFileExceptionErrorMessage;
import com.openexchange.filemanagement.ManagedFileManagement;
import com.openexchange.groupware.upload.impl.UploadException;
import com.openexchange.mail.mime.ContentType;
import com.openexchange.mail.mime.MimeType2ExtMap;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import java.io.File;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;

@Action(method=RequestMethod.GET, name="get", description="Requesting a formerly uploaded file", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module."), @Parameter(name="id", description="The ID of the uploaded file.")}, responseDescription="The content of the requested file is directly written into output stream.")
@DispatcherNotes(defaultFormat="file", allowPublicSession=true)
public final class GetAction
implements AJAXActionService {
    @Override
    public AJAXRequestResult perform(AJAXRequestData requestData, ServerSession session) throws OXException {
        try {
            ManagedFile file;
            String id = requestData.getParameter("id");
            if (id == null || id.length() == 0) {
                throw UploadException.UploadCode.MISSING_PARAM.create("id").setAction("get");
            }
            ManagedFileManagement management = ServerServiceRegistry.getInstance().getService(ManagedFileManagement.class);
            try {
                file = management.getByID(id);
            }
            catch (OXException e) {
                if (requestData.setResponseHeader("Content-Type", "text/html; charset=UTF-8") && (ManagedFileExceptionErrorMessage.NOT_FOUND.equals(e) || ManagedFileExceptionErrorMessage.FILE_NOT_FOUND.equals(e))) {
                    try {
                        HttpServletResponse resp = requestData.optHttpServletResponse();
                        resp.setStatus(404);
                        String desc = "An error occurred inside the server which prevented it from fulfilling the request.";
                        SessionServlet.writeErrorPage(404, desc, resp);
                        return new AJAXRequestResult(AJAXRequestResult.DIRECT_OBJECT, "direct").setType(AJAXRequestResult.ResultType.DIRECT);
                    }
                    catch (IOException ioe) {
                        throw AjaxExceptionCodes.IO_ERROR.create(ioe, ioe.getMessage());
                    }
                }
                throw e;
            }
            String fileName = file.getFileName();
            String disposition = file.getContentDisposition();
            ContentType contentType = new ContentType(file.getContentType());
            if (null != fileName) {
                if (contentType.startsWith("application/octet-stream")) {
                    String ct = MimeType2ExtMap.getContentType(fileName);
                    int pos = ct.indexOf(47);
                    contentType.setPrimaryType(ct.substring(0, pos));
                    contentType.setSubType(ct.substring(pos + 1));
                }
                contentType.setParameter("name", fileName);
            }
            File tmpFile = file.getFile();
            FileHolder fileHolder = new FileHolder(FileHolder.newClosureFor(tmpFile), tmpFile.length(), null, null);
            if (fileName != null) {
                fileHolder.setName(fileName);
            }
            fileHolder.setContentType(contentType.toString());
            fileHolder.setDisposition(disposition);
            return new AJAXRequestResult((Object)fileHolder, "file");
        }
        catch (RuntimeException e) {
            throw ManagedFileExceptionErrorMessage.IO_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
    }
}

