/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.database.provider;

import com.openexchange.database.provider.DBProvider;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import java.sql.Connection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingDBProvider
implements DBProvider {
    private static final Logger LOG = LoggerFactory.getLogger(LoggingDBProvider.class);
    private static final String PREFIX = "!!!DBPROVIDER!!! ";
    private final DBProvider delegate;

    public LoggingDBProvider(DBProvider delegate) {
        this.delegate = delegate;
    }

    @Override
    public Connection getReadConnection(Context ctx) throws OXException {
        LOG.trace("{}Getting read connection", (Object)PREFIX);
        return this.delegate.getReadConnection(ctx);
    }

    @Override
    public void releaseReadConnection(Context ctx, Connection con) {
        LOG.trace("{}Releasing read connection", (Object)PREFIX);
        this.delegate.releaseReadConnection(ctx, con);
    }

    @Override
    public Connection getWriteConnection(Context ctx) throws OXException {
        LOG.trace("{}Getting write connection", (Object)PREFIX);
        return this.delegate.getWriteConnection(ctx);
    }

    @Override
    public void releaseWriteConnection(Context ctx, Connection con) {
        LOG.trace("{}Releasing write connection", (Object)PREFIX);
        this.delegate.releaseWriteConnection(ctx, con);
    }

    @Override
    public void releaseWriteConnectionAfterReading(Context ctx, Connection con) {
        LOG.trace("{}Releasing write connection", (Object)PREFIX);
        this.delegate.releaseWriteConnectionAfterReading(ctx, con);
    }
}

