/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.data.conversion.ical.internal;

import com.openexchange.ajax.container.ThresholdFileHolder;
import com.openexchange.api2.AppointmentSQLInterface;
import com.openexchange.data.conversion.ical.ConversionError;
import com.openexchange.data.conversion.ical.ConversionWarning;
import com.openexchange.data.conversion.ical.ICalParser;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.calendar.AppointmentSqlFactoryService;
import com.openexchange.groupware.calendar.CalendarDataObject;
import com.openexchange.groupware.container.CalendarObject;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.groupware.tasks.TasksSQLImpl;
import com.openexchange.java.Streams;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.oxfolder.OXFolderAccess;
import com.openexchange.tools.session.ServerSession;
import java.io.Closeable;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;

public class ICalUtil {
    public static List<CalendarDataObject> importAppointments(InputStream inputStream, ServerSession session, int folderID) throws OXException {
        List<CalendarDataObject> appointments = ICalUtil.parseAppointments(inputStream, session);
        if (null != appointments && 0 < appointments.size()) {
            AppointmentSQLInterface appointmentSql = ServerServiceRegistry.getInstance().getService(AppointmentSqlFactoryService.class).createAppointmentSql(session);
            for (CalendarDataObject appointment : appointments) {
                appointment.setContext(session.getContext());
                appointment.setParentFolderID(folderID);
                appointmentSql.insertAppointmentObject(appointment);
            }
        }
        return appointments;
    }

    public static List<Task> importTasks(InputStream inputStream, ServerSession session, int folderID) throws OXException {
        List<Task> tasks2 = ICalUtil.parseTasks(inputStream, session);
        if (null != tasks2 && 0 < tasks2.size()) {
            TasksSQLImpl tasksSql = new TasksSQLImpl(session);
            for (Task task : tasks2) {
                task.setParentFolderID(folderID);
                tasksSql.insertTaskObject(task);
            }
        }
        return tasks2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<CalendarObject> importToDefaultFolder(InputStream inputStream, ServerSession session) throws OXException {
        OXFolderAccess access = new OXFolderAccess(session.getContext());
        FolderObject taskFolder = access.getDefaultFolder(session.getUserId(), 1);
        FolderObject calendarFolder = access.getDefaultFolder(session.getUserId(), 2);
        ArrayList<CalendarObject> calendarItems = new ArrayList<CalendarObject>();
        ThresholdFileHolder fileHolder = null;
        try {
            fileHolder = new ThresholdFileHolder();
            fileHolder.write(inputStream);
            calendarItems.addAll(ICalUtil.importAppointments(fileHolder.getStream(), session, calendarFolder.getObjectID()));
            calendarItems.addAll(ICalUtil.importTasks(fileHolder.getStream(), session, taskFolder.getObjectID()));
        }
        catch (Throwable throwable) {
            Streams.close((Closeable[])new Closeable[]{inputStream, fileHolder});
            throw throwable;
        }
        Streams.close((Closeable[])new Closeable[]{inputStream, fileHolder});
        return calendarItems;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<CalendarDataObject> parseAppointments(InputStream inputStream, ServerSession session) throws OXException {
        try {
            ICalParser iCalParser = ServerServiceRegistry.getServize(ICalParser.class, true);
            List<CalendarDataObject> list = iCalParser.parseAppointments(inputStream, TimeZone.getTimeZone(session.getUser().getTimeZone()), session.getContext(), new ArrayList<ConversionError>(), new ArrayList<ConversionWarning>());
            return list;
        }
        finally {
            Streams.close((Closeable)inputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Task> parseTasks(InputStream inputStream, ServerSession session) throws OXException {
        try {
            ICalParser iCalParser = ServerServiceRegistry.getServize(ICalParser.class, true);
            List<Task> list = iCalParser.parseTasks(inputStream, TimeZone.getTimeZone(session.getUser().getTimeZone()), session.getContext(), new ArrayList<ConversionError>(), new ArrayList<ConversionWarning>());
            return list;
        }
        finally {
            Streams.close((Closeable)inputStream);
        }
    }

    private ICalUtil() {
    }
}

