/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.consistency.solver;

import com.openexchange.consistency.Entity;
import com.openexchange.consistency.solver.ProblemSolver;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.infostore.database.impl.DatabaseImpl;
import java.text.MessageFormat;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteInfoitemSolver
implements ProblemSolver {
    private static final Logger LOG = LoggerFactory.getLogger(DeleteInfoitemSolver.class);
    private final DatabaseImpl database;

    public DeleteInfoitemSolver(DatabaseImpl database) {
        this.database = database;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void solve(Entity entity, Set<String> problems) {
        if (entity.getType().equals((Object)Entity.EntityType.Context)) {
            for (String identifier : problems) {
                block19: {
                    this.database.startTransaction();
                    this.database.startDBTransaction();
                    this.database.setRequestTransactional(true);
                    int[] numbers = this.database.removeDocument(identifier, entity.getContext());
                    this.database.commit();
                    if (numbers[0] == 1) {
                        LOG.info(MessageFormat.format("Have to change infostore version number for entry: {0}", identifier));
                    }
                    if (numbers[1] != 1) break block19;
                    LOG.info(MessageFormat.format("Deleted entry {0} from infostore_documents.", identifier));
                }
                try {
                    this.database.finish();
                }
                catch (OXException e) {
                    LOG.debug("", (Throwable)e);
                }
                continue;
                catch (OXException e) {
                    LOG.error("", (Throwable)e);
                    this.database.rollback();
                    try {
                        this.database.finish();
                    }
                    catch (OXException e2) {
                        LOG.debug("", (Throwable)e2);
                    }
                    return;
                    {
                        catch (OXException e1) {
                            try {
                                LOG.debug("", (Throwable)e1);
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                            finally {
                                try {
                                    this.database.finish();
                                }
                                catch (OXException e3) {
                                    LOG.debug("", (Throwable)e3);
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public String description() {
        return "delete infoitem";
    }
}

