/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.consistency.solver;

import com.openexchange.consistency.Entity;
import com.openexchange.consistency.osgi.ConsistencyServiceLookup;
import com.openexchange.consistency.solver.ProblemSolver;
import com.openexchange.contact.vcard.storage.VCardStorageMetadataStore;
import com.openexchange.exception.OXException;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteBrokenVCardReferencesSolver
implements ProblemSolver {
    private static final Logger LOG = LoggerFactory.getLogger(DeleteBrokenVCardReferencesSolver.class);

    @Override
    public void solve(Entity entity, Set<String> problems) throws OXException {
        if (entity.getType().equals((Object)Entity.EntityType.Context)) {
            VCardStorageMetadataStore vCardStorageMetadataStore = ConsistencyServiceLookup.getOptionalService(VCardStorageMetadataStore.class);
            if (vCardStorageMetadataStore == null) {
                LOG.warn("Required service VCardStorageMetadataStore absent. Unable to solve VCard related consistency issues on storage.");
                return;
            }
            if (problems.size() > 0) {
                vCardStorageMetadataStore.removeByRefId(entity.getContext().getContextId(), problems);
                LOG.info("Deleted {} broken VCard references.", (Object)problems.size());
            }
        }
    }

    @Override
    public String description() {
        return "delete broken VCard references";
    }
}

