/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.consistency.solver;

import com.openexchange.consistency.Entity;
import com.openexchange.consistency.solver.ProblemSolver;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.attach.AttachmentBase;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteAttachmentSolver
implements ProblemSolver {
    private static final Logger LOG = LoggerFactory.getLogger(DeleteAttachmentSolver.class);
    private final AttachmentBase attachments;

    public DeleteAttachmentSolver(AttachmentBase attachments2) {
        this.attachments = attachments2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void solve(Entity entity, Set<String> problems) {
        if (entity.getType().equals((Object)Entity.EntityType.Context)) {
            Iterator<String> it = problems.iterator();
            while (it.hasNext()) {
                try {
                    String identifier = it.next();
                    this.attachments.setTransactional(true);
                    this.attachments.startTransaction();
                    int[] numbers = this.attachments.removeAttachment(identifier, entity.getContext());
                    this.attachments.commit();
                    if (numbers[0] == 1) {
                        LOG.info(MessageFormat.format("Inserted entry for identifier {0} and Context {1} in del_attachments", identifier, entity.getContext().getContextId()));
                    }
                    if (numbers[1] != 1) continue;
                    LOG.info(MessageFormat.format("Removed attachment database entry for: {0}", identifier));
                }
                catch (OXException e) {
                    LOG.debug("", (Throwable)e);
                    try {
                        this.attachments.rollback();
                        return;
                    }
                    catch (OXException e1) {
                        LOG.debug("", (Throwable)e1);
                        return;
                    }
                }
                catch (RuntimeException e) {
                    LOG.error("", (Throwable)e);
                    try {
                        this.attachments.rollback();
                        return;
                    }
                    catch (OXException e1) {
                        LOG.debug("", (Throwable)e1);
                        return;
                    }
                }
                finally {
                    try {
                        this.attachments.finish();
                    }
                    catch (OXException e) {
                        LOG.debug("", (Throwable)e);
                    }
                }
            }
        }
    }

    @Override
    public String description() {
        return "delete attachment";
    }
}

