/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.consistency;

import com.openexchange.ajax.requesthandler.cache.ResourceCacheMetadataStore;
import com.openexchange.consistency.Consistency;
import com.openexchange.consistency.Entity;
import com.openexchange.consistency.EntityImpl;
import com.openexchange.consistency.osgi.ConsistencyServiceLookup;
import com.openexchange.contact.vcard.storage.VCardStorageMetadataStore;
import com.openexchange.database.DBPoolingExceptionCodes;
import com.openexchange.database.DatabaseService;
import com.openexchange.database.Databases;
import com.openexchange.database.provider.DBPoolProvider;
import com.openexchange.exception.OXException;
import com.openexchange.filestore.FileStorage;
import com.openexchange.filestore.FileStorage2EntitiesResolver;
import com.openexchange.filestore.FileStorageCodes;
import com.openexchange.filestore.FileStorages;
import com.openexchange.groupware.attach.AttachmentBase;
import com.openexchange.groupware.attach.AttachmentExceptionCodes;
import com.openexchange.groupware.attach.Attachments;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.infostore.database.impl.DatabaseImpl;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.sql.DBUtils;
import edu.emory.mathcs.backport.java.util.Collections;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class OsgiOXConsistency
extends Consistency {
    private DatabaseImpl database;

    @Override
    protected Context getContext(int contextId) throws OXException {
        ContextStorage ctxstor = ContextStorage.getInstance();
        return ctxstor.getContext(contextId);
    }

    @Override
    protected DatabaseImpl getDatabase() {
        if (this.database == null) {
            this.database = new DatabaseImpl(new DBPoolProvider());
        }
        return this.database;
    }

    @Override
    protected AttachmentBase getAttachments() {
        return Attachments.getInstance();
    }

    @Override
    protected FileStorage getFileStorage(Entity entity) throws OXException {
        switch (entity.getType()) {
            case Context: {
                return this.getFileStorage(entity.getContext());
            }
            case User: {
                return this.getFileStorage(entity.getContext(), entity.getUser());
            }
        }
        throw new IllegalArgumentException("Unknown entity type: " + (Object)((Object)entity.getType()));
    }

    @Override
    protected FileStorage getFileStorage(Context ctx) throws OXException {
        FileStorage2EntitiesResolver resolver = FileStorages.getFileStorage2EntitiesResolver();
        return resolver.getFileStorageUsedBy(ctx.getContextId(), true);
    }

    @Override
    protected FileStorage getFileStorage(Context context, User user) throws OXException {
        FileStorage2EntitiesResolver resolver = FileStorages.getFileStorage2EntitiesResolver();
        return resolver.getFileStorageUsedBy(context.getContextId(), user.getId(), true);
    }

    @Override
    protected List<Context> getContextsForFilestore(int filestoreId) throws OXException {
        DatabaseService dbService = ServerServiceRegistry.getInstance().getService(DatabaseService.class, true);
        Connection connection = dbService.getReadOnly();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = connection.prepareStatement("SELECT 1 FROM filestore WHERE id=?");
            stmt.setInt(1, filestoreId);
            rs = stmt.executeQuery();
            if (!rs.next()) {
                throw FileStorageCodes.NO_SUCH_FILE_STORAGE.create(new Object[]{filestoreId});
            }
        }
        catch (SQLException e) {
            try {
                throw DBPoolingExceptionCodes.SQL_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
            }
            catch (Throwable throwable) {
                Databases.closeSQLStuff(rs, (Statement)stmt);
                dbService.backReadOnly(connection);
                throw throwable;
            }
        }
        Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
        dbService.backReadOnly(connection);
        int[] ids = FileStorages.getFileStorage2EntitiesResolver().getIdsOfContextsUsing(filestoreId);
        return this.loadContexts(ids);
    }

    @Override
    protected List<Entity> getEntitiesForFilestore(int filestoreId) throws OXException {
        List<Context> ctxs = this.getContextsForFilestore(filestoreId);
        Map<Context, List<User>> users = this.getUsersForFilestore(filestoreId);
        ArrayList<Entity> entities = new ArrayList<Entity>(ctxs.size() + users.size());
        for (Context context : ctxs) {
            entities.add(new EntityImpl(context));
        }
        for (Map.Entry entry : users.entrySet()) {
            for (User user : (List)entry.getValue()) {
                entities.add(new EntityImpl((Context)entry.getKey(), user));
            }
        }
        return entities;
    }

    @Override
    protected List<Context> getContextsForDatabase(int databaseId) throws OXException {
        DatabaseService configDB = ServerServiceRegistry.getInstance().getService(DatabaseService.class, true);
        Connection connection = configDB.getReadOnly();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = connection.prepareStatement("SELECT 1 FROM db_pool WHERE db_pool_id=?");
            stmt.setInt(1, databaseId);
            rs = stmt.executeQuery();
            if (!rs.next()) {
                throw DBPoolingExceptionCodes.NO_DBPOOL.create(new Object[]{databaseId});
            }
        }
        catch (SQLException e) {
            try {
                throw DBPoolingExceptionCodes.SQL_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
            }
            catch (Throwable throwable) {
                Databases.closeSQLStuff(rs, (Statement)stmt);
                configDB.backReadOnly(connection);
                throw throwable;
            }
        }
        Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
        configDB.backReadOnly(connection);
        int[] contextIds = configDB.listContexts(databaseId);
        return this.loadContexts(contextIds);
    }

    @Override
    protected List<Context> getAllContexts() throws OXException {
        ContextStorage ctxstor = ContextStorage.getInstance();
        List<Integer> list = ctxstor.getAllContextIds();
        return this.loadContexts(list);
    }

    @Override
    protected User getAdmin(Context ctx) throws OXException {
        return UserStorage.getInstance().getUser(ctx.getMailadmin(), ctx);
    }

    @Override
    protected SortedSet<String> getSnippetFileStoreLocationsPerContext(Context ctx) throws OXException {
        TreeSet<String> retval = new TreeSet<String>();
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        DatabaseService databaseService = ConsistencyServiceLookup.getService(DatabaseService.class, true);
        try {
            con = databaseService.getReadOnly(ctx);
            if (DBUtils.tableExists(con, "snippet")) {
                stmt = con.prepareStatement("SELECT refId FROM snippet WHERE cid=? AND refType=1");
                stmt.setInt(1, ctx.getContextId());
                rs = stmt.executeQuery();
                while (rs.next()) {
                    retval.add(rs.getString(1));
                }
                DBUtils.closeSQLStuff(rs, stmt);
                stmt = null;
            }
        }
        catch (SQLException e) {
            throw AttachmentExceptionCodes.SQL_PROBLEM.create(e, DBUtils.getStatement(stmt));
        }
        finally {
            DBUtils.closeSQLStuff(rs, stmt);
            if (null != con) {
                databaseService.backReadOnly(ctx, con);
            }
        }
        return retval;
    }

    @Override
    protected SortedSet<String> getVCardFileStoreLocationsPerContext(Context ctx) throws OXException {
        VCardStorageMetadataStore vCardStorageMetadataStore = ConsistencyServiceLookup.getOptionalService(VCardStorageMetadataStore.class);
        if (vCardStorageMetadataStore != null) {
            Set loadRefIds = vCardStorageMetadataStore.loadRefIds(ctx.getContextId());
            return new TreeSet<String>(loadRefIds);
        }
        return new TreeSet<String>();
    }

    @Override
    protected SortedSet<String> getPreviewCacheFileStoreLocationsPerContext(Context ctx) throws OXException {
        ResourceCacheMetadataStore metadataStore = ResourceCacheMetadataStore.getInstance();
        Set<String> refIds = metadataStore.loadRefIds(ctx.getContextId());
        return new TreeSet<String>(refIds);
    }

    private List<Context> loadContexts(List<Integer> list) throws OXException {
        ContextStorage ctxstor = ContextStorage.getInstance();
        ArrayList<Context> contexts = new ArrayList<Context>(list.size());
        for (int id : list) {
            contexts.add(ctxstor.getContext(id));
        }
        return contexts;
    }

    private List<Context> loadContexts(int[] list) throws OXException {
        ContextStorage ctxstor = ContextStorage.getInstance();
        ArrayList<Context> contexts = new ArrayList<Context>(list.length);
        for (int id : list) {
            contexts.add(ctxstor.getContext(id));
        }
        return contexts;
    }

    private Map<Context, List<User>> loadUsers(Map<Integer, List<Integer>> users) throws OXException {
        ContextStorage ctxStor = ContextStorage.getInstance();
        UserStorage usrStor = UserStorage.getInstance();
        HashMap<Context, List<User>> usr = new HashMap<Context, List<User>>();
        for (Map.Entry<Integer, List<Integer>> ctxIdEntry : users.entrySet()) {
            Context context = ctxStor.getContext(ctxIdEntry.getKey());
            Object[] usrArray = usrStor.getUser(context, this.toArray(ctxIdEntry.getValue()));
            ArrayList usrList = new ArrayList(usrArray.length);
            Collections.addAll(usrList, (Object[])usrArray);
            usr.put(context, usrList);
        }
        return usr;
    }

    private Map<Context, List<User>> getUsersForFilestore(int filestoreId) throws OXException {
        Map users = FileStorages.getFileStorage2EntitiesResolver().getIdsOfUsersUsing(filestoreId);
        return this.loadUsers(users);
    }

    private int[] toArray(List<Integer> list) {
        int[] integers = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            integers[i] = list.get(i);
        }
        return integers;
    }
}

