/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.consistency;

import com.openexchange.consistency.Entity;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import org.apache.commons.collections.keyvalue.MultiKey;

public class EntityImpl
implements Entity {
    private static final long serialVersionUID = -4838502301287665200L;
    private Entity.EntityType type;
    private MultiKey identifier;
    private Context context;
    private User user;

    public EntityImpl(Context context) {
        this(new MultiKey(new Object[]{context.getContextId()}));
        this.context = context;
    }

    public EntityImpl(Context context, User user) {
        this(new MultiKey((Object)context.getContextId(), (Object)user.getId()));
        this.context = context;
        this.user = user;
    }

    private EntityImpl(MultiKey identifier) {
        if (identifier == null) {
            throw new IllegalArgumentException("The identifiers can not be 'null'.");
        }
        this.identifier = identifier;
        switch (identifier.getKeys().length) {
            case 1: {
                this.type = Entity.EntityType.Context;
                break;
            }
            case 2: {
                this.type = Entity.EntityType.User;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid amount of identifiers specified: " + identifier.getKeys().length);
            }
        }
    }

    @Override
    public MultiKey getId() {
        return this.identifier;
    }

    @Override
    public Entity.EntityType getType() {
        return this.type;
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    @Override
    public User getUser() {
        return this.user;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Entity [type=").append((Object)this.type).append(", identifier=").append(this.identifier).append("]");
        return builder.toString();
    }
}

