/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.configuration;

import com.openexchange.config.ConfigurationService;
import com.openexchange.config.Reloadable;
import com.openexchange.configuration.ConfigurationExceptionCodes;
import com.openexchange.exception.OXException;
import com.openexchange.server.Initialization;
import com.openexchange.tools.conf.AbstractConfig;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SystemConfig
extends AbstractConfig
implements Initialization,
Reloadable {
    private static final SystemConfig singleton = new SystemConfig();
    private static final Logger LOG = LoggerFactory.getLogger(SystemConfig.class);
    private static final String KEY = "openexchange.propdir";
    private static final String[] PROPERTIES = new String[]{"all properties in file"};

    public static String getProperty(String key) {
        return SystemConfig.getProperty(key, null);
    }

    public static String getProperty(String key, String def) {
        return singleton.getPropertyInternal(key, def);
    }

    public static String getProperty(Property property) {
        return SystemConfig.getProperty(property.propertyName);
    }

    public static boolean isPropertiesLoad() {
        return null != singleton && singleton.isPropertiesLoadInternal();
    }

    public static SystemConfig getInstance() {
        return singleton;
    }

    private SystemConfig() {
    }

    public void reloadConfiguration(ConfigurationService configService) {
        try {
            this.stop();
            this.start();
        }
        catch (OXException e) {
            LOG.warn("Could not reload system configuration.", (Throwable)e);
        }
    }

    public void start() throws OXException {
        if (this.isPropertiesLoadInternal()) {
            LOG.error("Duplicate initialization of SystemConfig.");
            return;
        }
        this.loadPropertiesInternal();
    }

    public void stop() {
        this.clearProperties();
    }

    @Override
    protected String getPropertyFileName() throws OXException {
        String directory = System.getProperty(KEY);
        if (null == directory) {
            throw ConfigurationExceptionCodes.PROPERTY_MISSING.create(KEY);
        }
        return directory + File.separator + "system.properties";
    }

    public Map<String, String[]> getConfigFileNames() {
        HashMap<String, String[]> map = new HashMap<String, String[]>(1);
        map.put("system.properties", PROPERTIES);
        return map;
    }

    public static enum Property {
        LDAP("LDAP"),
        CACHE("Cache"),
        USER_CONF_STORAGE("UserConfigurationStorage"),
        WebdavOverrides("WEBDAVOVERRIDES"),
        MimeTypeFileName("MimeTypeFileName");

        private String propertyName;

        private Property(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

