/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.config.json;

import com.openexchange.ajax.requesthandler.AJAXActionService;
import com.openexchange.ajax.requesthandler.AJAXActionServiceFactory;
import com.openexchange.config.json.actions.GETAction;
import com.openexchange.config.json.actions.GetPropertyAction;
import com.openexchange.config.json.actions.PUTAction;
import com.openexchange.config.json.actions.SetPropertyAction;
import com.openexchange.documentation.annotations.Module;
import com.openexchange.exception.OXException;
import com.openexchange.oauth.provider.resourceserver.annotations.OAuthModule;
import com.openexchange.server.ServiceLookup;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Module(name="config", description="The config module is used to retrieve and set user-specific configuration.")
@OAuthModule
public class ConfigActionFactory
implements AJAXActionServiceFactory {
    public static final String OAUTH_WRITE_SCOPE = "write_userconfig";
    private final Map<String, AJAXActionService> actions = new ConcurrentHashMap<String, AJAXActionService>(2, 0.9f, 1);

    public ConfigActionFactory(ServiceLookup services) {
        this.actions.put("GET", new GETAction(services));
        this.actions.put("PUT", new PUTAction(services));
        this.actions.put("get_property", new GetPropertyAction(services));
        this.actions.put("set_property", new SetPropertyAction(services));
    }

    @Override
    public AJAXActionService createActionService(String action) throws OXException {
        return this.actions.get(action);
    }

    public Collection<? extends AJAXActionService> getSupportedServices() {
        return Collections.unmodifiableCollection(this.actions.values());
    }
}

