/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.authentication.service.osgi;

import com.openexchange.authentication.BasicAuthenticationService;
import com.openexchange.authentication.basic.DefaultBasicAuthentication;
import com.openexchange.authentication.service.Authentication;
import com.openexchange.context.ContextService;
import com.openexchange.user.UserService;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BasicAuthenticationRegisterer
implements ServiceTrackerCustomizer<Object, Object> {
    private static final Logger LOG = LoggerFactory.getLogger(BasicAuthenticationRegisterer.class);
    private final BundleContext context;
    private final Lock lock;
    private ServiceRegistration<BasicAuthenticationService> registration;
    private ContextService contextService;
    private UserService userService;

    public BasicAuthenticationRegisterer(BundleContext context) {
        this.context = context;
        this.lock = new ReentrantLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object addingService(ServiceReference<Object> reference) {
        Object obj = this.context.getService(reference);
        this.lock.lock();
        try {
            boolean needsRegistration;
            if (obj instanceof ContextService) {
                this.contextService = (ContextService)obj;
            }
            if (obj instanceof UserService) {
                this.userService = (UserService)obj;
            }
            boolean bl = needsRegistration = null != this.contextService && null != this.userService && this.registration == null;
            if (needsRegistration) {
                LOG.info("Registering default basic authentication service.");
                DefaultBasicAuthentication basicAuthentication = new DefaultBasicAuthentication(this.contextService, this.userService);
                this.registration = this.context.registerService(BasicAuthenticationService.class, (Object)basicAuthentication, null);
                Authentication.setBasicService(basicAuthentication);
            }
        }
        finally {
            this.lock.unlock();
        }
        return obj;
    }

    public void modifiedService(ServiceReference<Object> reference, Object service) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removedService(ServiceReference<Object> reference, Object service) {
        ServiceRegistration<BasicAuthenticationService> unregister = null;
        this.lock.lock();
        try {
            if (service instanceof ContextService) {
                this.contextService = null;
            }
            if (service instanceof UserService) {
                this.userService = null;
            }
            if (this.registration != null && (this.contextService == null || this.userService == null)) {
                unregister = this.registration;
                this.registration = null;
            }
            if (null != unregister) {
                LOG.info("Unregistering default basic authentication service.");
                unregister.unregister();
                Authentication.setBasicService(null);
            }
        }
        finally {
            this.lock.unlock();
        }
        this.context.ungetService(reference);
    }
}

