/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.tools;

import com.openexchange.exception.OXException;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public final class JSONUtil {
    private static final String DATA = "data";

    private JSONUtil() {
    }

    public static JSONObject rightMerge(JSONObject jObject1, JSONObject ... jObjects) throws JSONException {
        if (null == jObject1 || null == jObjects || 0 == jObjects.length) {
            return jObject1;
        }
        for (JSONObject obj : jObjects) {
            if (null == obj) continue;
            for (Map.Entry entry : obj.entrySet()) {
                jObject1.put((String)entry.getKey(), entry.getValue());
            }
        }
        return jObject1;
    }

    public static JSONObject merge(JSONObject jObject1, JSONObject ... jObjects) throws JSONException {
        if (null == jObject1) {
            return jObject1;
        }
        JSONObject merged = new JSONObject(jObject1.length());
        for (Map.Entry entry : jObject1.entrySet()) {
            merged.put((String)entry.getKey(), entry.getValue());
        }
        if (null == jObjects || 0 == jObjects.length) {
            return merged;
        }
        for (JSONObject obj : jObjects) {
            if (null == obj) continue;
            JSONUtil.mergeInto(merged, obj);
        }
        return merged;
    }

    private static void mergeInto(JSONObject j1, JSONObject j2) throws JSONException {
        Iterator keys2 = j2.keys();
        while (keys2.hasNext()) {
            Object object1;
            String key = (String)keys2.next();
            Object object2 = j2.get(key);
            if (JSONUtil.isJSONObject(object2)) {
                if (j1.hasAndNotNull(key)) {
                    object1 = j1.get(key);
                    if (!JSONUtil.isJSONObject(object1)) {
                        throw new JSONException("JSON merge failed for key \"" + key + "\": Incompatible values " + object1.getClass().getSimpleName() + " != " + object2.getClass().getSimpleName());
                    }
                    JSONUtil.mergeInto((JSONObject)object1, (JSONObject)object2);
                    j1.put(key, object1);
                    continue;
                }
                j1.put(key, object2);
                continue;
            }
            if (JSONUtil.isJSONArray(object2)) {
                if (j1.hasAndNotNull(key)) {
                    object1 = j1.get(key);
                    if (!JSONUtil.isJSONArray(object1)) {
                        throw new JSONException("JSON merge failed for key \"" + key + "\": Incompatible values " + object1.getClass().getSimpleName() + " != " + object2.getClass().getSimpleName());
                    }
                    JSONUtil.mergeInto((JSONArray)object1, (JSONArray)object2);
                    j1.put(key, object1);
                    continue;
                }
                j1.put(key, object2);
                continue;
            }
            j1.put(key, object2);
        }
    }

    private static boolean isJSONObject(Object o) {
        return o instanceof JSONObject;
    }

    private static boolean isJSONArray(Object o) {
        return o instanceof JSONArray;
    }

    private static void mergeInto(JSONArray a1, JSONArray a2) throws JSONException {
        int len = a2.length();
        for (int i = 0; i < len; ++i) {
            Object object = a2.get(i);
            if (JSONUtil.contains(a1, object)) continue;
            a1.put(object);
        }
    }

    private static boolean contains(JSONArray jsonArray, Object object) throws JSONException {
        int len = jsonArray.length();
        for (int i = 0; i < len; ++i) {
            if (!jsonArray.get(i).equals(object)) continue;
            return true;
        }
        return false;
    }

    public static Object toObject(String value) throws JSONException {
        if (null == value) {
            return null;
        }
        return new JSONTokener(value).nextValue();
    }

    public static String requireString(String name, JSONObject jsonObject) throws OXException {
        try {
            String value = jsonObject.optString(name, null);
            if (null == value) {
                throw AjaxExceptionCodes.MISSING_PARAMETER.create(name);
            }
            return value;
        }
        catch (RuntimeException e) {
            throw AjaxExceptionCodes.MISSING_PARAMETER.create(e, name);
        }
    }

    public static int requireInt(String name, JSONObject jsonObject) throws OXException {
        try {
            if (!jsonObject.has(name)) {
                throw AjaxExceptionCodes.MISSING_PARAMETER.create(name);
            }
            return jsonObject.optInt(name, -1);
        }
        catch (RuntimeException e) {
            throw AjaxExceptionCodes.MISSING_PARAMETER.create(e, name);
        }
    }

    public static boolean requireBoolean(String name, JSONObject jsonObject) throws OXException {
        try {
            if (!jsonObject.has(name)) {
                throw AjaxExceptionCodes.MISSING_PARAMETER.create(name);
            }
            return jsonObject.optBoolean(name, false);
        }
        catch (RuntimeException e) {
            throw AjaxExceptionCodes.MISSING_PARAMETER.create(e, name);
        }
    }

    public static JSONObject requireDataObject(JSONObject jsonObject) throws OXException {
        try {
            JSONObject value = jsonObject.optJSONObject(DATA);
            if (null == value) {
                throw AjaxExceptionCodes.MISSING_REQUEST_BODY.create();
            }
            return value;
        }
        catch (RuntimeException e) {
            throw AjaxExceptionCodes.MISSING_REQUEST_BODY.create(e, new Object[0]);
        }
    }
}

