/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler.responseRenderers;

import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.requesthandler.ResponseRenderer;
import com.openexchange.ajax.requesthandler.responseRenderers.APIResponseRenderer;
import com.openexchange.exception.OXException;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class JSONResponseRenderer
implements ResponseRenderer {
    private static final String FORMAT = "json";

    @Override
    public int getRanking() {
        return 0;
    }

    @Override
    public boolean handles(AJAXRequestData request, AJAXRequestResult result) {
        return FORMAT.equalsIgnoreCase(result.getFormat());
    }

    @Override
    public void write(AJAXRequestData request, AJAXRequestResult result, HttpServletRequest req, HttpServletResponse resp) {
        Response response = new Response(request.getSession());
        response.setData(result.getResultObject());
        response.setTimestamp(result.getTimestamp());
        response.setProperties(result.getResponseProperties());
        Collection<OXException> warnings = result.getWarnings();
        if (null != warnings && !warnings.isEmpty()) {
            for (OXException warning : warnings) {
                response.addWarning(warning);
            }
        }
        APIResponseRenderer.writeResponse(response, request.getAction(), req, resp);
    }
}

