/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler.responseRenderers;

import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.requesthandler.HttpErrorCodeException;
import com.openexchange.ajax.requesthandler.ListenerCollectingResponseRenderer;
import com.openexchange.ajax.requesthandler.responseRenderers.RenderListener;
import com.openexchange.exception.OXException;
import com.openexchange.servlet.StatusKnowing;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractListenerCollectingResponseRenderer
implements ListenerCollectingResponseRenderer {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractListenerCollectingResponseRenderer.class);
    protected final Queue<RenderListener> renderListenerRegistry = new ConcurrentLinkedQueue<RenderListener>();
    protected volatile boolean hasRenderListeners;

    protected AbstractListenerCollectingResponseRenderer() {
    }

    @Override
    public void addRenderListener(RenderListener listener) {
        if (null != listener && this.renderListenerRegistry.add(listener)) {
            this.hasRenderListeners = true;
        }
    }

    @Override
    public void removeRenderListener(RenderListener listener) {
        if (null != listener && this.renderListenerRegistry.remove(listener)) {
            this.hasRenderListeners = false == this.renderListenerRegistry.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(AJAXRequestData request, AJAXRequestResult result, HttpServletRequest req, HttpServletResponse resp) {
        if (!this.hasRenderListeners) {
            this.actualWrite(request, result, req, resp);
            return;
        }
        LinkedList<RenderListener> applicableListeners = new LinkedList<RenderListener>();
        for (RenderListener renderListener : this.renderListenerRegistry) {
            if (!renderListener.handles(request)) continue;
            applicableListeners.add(renderListener);
        }
        if (applicableListeners.isEmpty()) {
            this.actualWrite(request, result, req, resp);
            return;
        }
        StatusKnowing statusKnowing = null;
        if (resp instanceof StatusKnowing) {
            statusKnowing = (StatusKnowing)resp;
        }
        try {
            this.beforeWrite(request, result, req, resp, applicableListeners);
            if (null != statusKnowing && this.isError(statusKnowing.getStatus())) {
                return;
            }
        }
        catch (OXException e) {
            LOG.error("Skipped using renderer '{}' due to an error.", (Object)this.getClass().getName(), (Object)e);
            return;
        }
        Exception exceptionCausedByActualWrite = null;
        try {
            int status;
            this.actualWrite(request, result, req, resp);
            if (null != statusKnowing && this.isError(status = ((StatusKnowing)resp).getStatus())) {
                exceptionCausedByActualWrite = new HttpErrorCodeException(status);
            }
        }
        catch (RuntimeException e) {
            exceptionCausedByActualWrite = e;
            LOG.error("Skipped using renderer '{}' due to an error.", (Object)this.getClass().getName(), (Object)e);
        }
        finally {
            try {
                this.afterWrite(request, result, exceptionCausedByActualWrite, applicableListeners);
            }
            catch (Exception e) {
                LOG.error("Skipped using renderer '{}' due to an error.", (Object)this.getClass().getName(), (Object)e);
            }
        }
    }

    private boolean isError(int status) {
        return status >= 400 && status <= 499 || status >= 500 && status <= 599;
    }

    public abstract void actualWrite(AJAXRequestData var1, AJAXRequestResult var2, HttpServletRequest var3, HttpServletResponse var4);

    protected void beforeWrite(AJAXRequestData requestData, AJAXRequestResult result, HttpServletRequest req, HttpServletResponse resp, Collection<RenderListener> listeners) throws OXException {
        for (RenderListener renderListener : listeners) {
            renderListener.onBeforeWrite(requestData, result, req, resp);
        }
    }

    public void afterWrite(AJAXRequestData requestData, AJAXRequestResult result, Exception writeException, Collection<RenderListener> listeners) throws OXException {
        for (RenderListener renderListener : listeners) {
            renderListener.onAfterWrite(requestData, result, writeException);
        }
    }
}

