/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler.osgi;

import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.ActionBoundDispatcherListener;
import com.openexchange.ajax.requesthandler.DispatcherListener;
import com.openexchange.ajax.requesthandler.DispatcherListenerRegistry;
import com.openexchange.exception.OXException;
import com.openexchange.java.Strings;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSGiDispatcherListenerRegistry
implements DispatcherListenerRegistry,
ServiceTrackerCustomizer<DispatcherListener, DispatcherListener> {
    private static final Logger LOG = LoggerFactory.getLogger(OSGiDispatcherListenerRegistry.class);
    private final BundleContext context;
    private final AtomicBoolean anyListenerAdded;
    private final Queue<DispatcherListener> allListeners;
    private final ConcurrentMap<String, Queue<DispatcherListener>> startsWithListeners;
    private final ConcurrentMap<ActionKey, Queue<DispatcherListener>> certainListeners;

    public OSGiDispatcherListenerRegistry(BundleContext context) {
        this.context = context;
        this.anyListenerAdded = new AtomicBoolean(false);
        this.allListeners = new ConcurrentLinkedQueue<DispatcherListener>();
        this.startsWithListeners = new ConcurrentHashMap<String, Queue<DispatcherListener>>(16, 0.9f, 1);
        this.certainListeners = new ConcurrentHashMap<ActionKey, Queue<DispatcherListener>>(16, 0.9f, 1);
    }

    public synchronized DispatcherListener addingService(ServiceReference<DispatcherListener> reference) {
        DispatcherListener listener = (DispatcherListener)this.context.getService(reference);
        if (this.add(listener)) {
            this.anyListenerAdded.set(true);
            return listener;
        }
        this.context.ungetService(reference);
        return null;
    }

    public void modifiedService(ServiceReference<DispatcherListener> reference, DispatcherListener listener) {
    }

    public synchronized void removedService(ServiceReference<DispatcherListener> reference, DispatcherListener listener) {
        this.remove(listener);
        this.context.ungetService(reference);
    }

    @Override
    public List<DispatcherListener> getDispatcherListenersFor(AJAXRequestData requestData) throws OXException {
        if (!this.anyListenerAdded.get()) {
            return Collections.emptyList();
        }
        LinkedList listeners = new LinkedList();
        String module = requestData.getNormalizedModule();
        if (Strings.isNotEmpty((String)module)) {
            Queue q;
            ActionKey actionKey;
            Queue q2;
            String action = requestData.getAction();
            if (Strings.isNotEmpty((String)action) && null != (q2 = (Queue)this.certainListeners.get(actionKey = new ActionKey(action, module)))) {
                listeners.addAll(q2);
            }
            if (null != (q = (Queue)this.startsWithListeners.get(module))) {
                listeners.addAll(q);
            }
        }
        LinkedList<DispatcherListener> applicables = new LinkedList<DispatcherListener>();
        for (DispatcherListener listener : listeners) {
            if (!listener.applicable(requestData)) continue;
            applicables.add(listener);
        }
        return applicables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean add(DispatcherListener listener) {
        if (!(listener instanceof ActionBoundDispatcherListener)) {
            return this.allListeners.offer(listener);
        }
        ActionBoundDispatcherListener actionBoundListener = (ActionBoundDispatcherListener)listener;
        String module = actionBoundListener.getModule();
        if (Strings.isEmpty((String)module)) {
            LOG.error("Action-bound dispatcher listener '{}' does not specify a module, but should.", (Object)listener.getClass().getName());
            return false;
        }
        Set<String> actions = actionBoundListener.getActions();
        if (null == actions || actions.isEmpty()) {
            return this.getQueueFor(module, this.startsWithListeners).offer(actionBoundListener);
        }
        LinkedList<Queue<DispatcherListener>> toRemoveFrom = new LinkedList<Queue<DispatcherListener>>();
        boolean added = true;
        try {
            Iterator<String> it = actions.iterator();
            while (added && it.hasNext()) {
                Queue<DispatcherListener> q = this.getQueueFor(new ActionKey(it.next(), module), this.certainListeners);
                added = q.offer(actionBoundListener);
                if (!added) continue;
                toRemoveFrom.add(q);
            }
            boolean bl = added;
            return bl;
        }
        finally {
            if (!added) {
                for (Queue queue : toRemoveFrom) {
                    queue.remove(actionBoundListener);
                }
            }
        }
    }

    private boolean remove(DispatcherListener listener) {
        if (!(listener instanceof ActionBoundDispatcherListener)) {
            return this.allListeners.remove(listener);
        }
        ActionBoundDispatcherListener actionBoundListener = (ActionBoundDispatcherListener)listener;
        String module = actionBoundListener.getModule();
        Set<String> actions = actionBoundListener.getActions();
        if (null == actions || actions.isEmpty()) {
            return this.getQueueFor(module, this.startsWithListeners).remove(actionBoundListener);
        }
        for (String action : actions) {
            this.getQueueFor(new ActionKey(action, module), this.certainListeners).remove(actionBoundListener);
        }
        return true;
    }

    private <K> Queue<DispatcherListener> getQueueFor(K key, ConcurrentMap<K, Queue<DispatcherListener>> map) {
        ConcurrentLinkedQueue nq;
        ConcurrentLinkedQueue q = (ConcurrentLinkedQueue)map.get(key);
        if (null == q && null == (q = (Queue)map.putIfAbsent(key, nq = new ConcurrentLinkedQueue()))) {
            q = nq;
        }
        return q;
    }

    private static final class ActionKey {
        private final String module;
        private final String action;
        private final int hash;

        ActionKey(String action, String module) {
            this.action = action;
            this.module = module;
            int prime = 31;
            int result = prime * 1 + (action == null ? 0 : action.hashCode());
            this.hash = result = prime * result + (module == null ? 0 : module.hashCode());
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ActionKey)) {
                return false;
            }
            ActionKey other = (ActionKey)obj;
            if (this.module == null ? other.module != null : !this.module.equals(other.module)) {
                return false;
            }
            return !(this.action == null ? other.action != null : !this.action.equals(other.action));
        }
    }
}

