/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler.oauth;

import com.openexchange.ajax.requesthandler.AJAXActionService;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AbstractAJAXActionAnnotationProcessor;
import com.openexchange.exception.OXException;
import com.openexchange.oauth.provider.exceptions.OAuthInsufficientScopeException;
import com.openexchange.oauth.provider.resourceserver.OAuthAccess;
import com.openexchange.oauth.provider.resourceserver.annotations.OAuthAction;
import com.openexchange.oauth.provider.resourceserver.annotations.OAuthScopeCheck;
import com.openexchange.tools.session.ServerSession;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthAnnotationProcessor
extends AbstractAJAXActionAnnotationProcessor<OAuthAction> {
    private static final Logger LOG = LoggerFactory.getLogger(OAuthAnnotationProcessor.class);

    @Override
    protected Class<OAuthAction> getAnnotation() {
        return OAuthAction.class;
    }

    @Override
    protected void doProcess(OAuthAction annotation, AJAXActionService action, AJAXRequestData requestData, ServerSession session) throws OXException {
        OAuthAccess oAuthAccess = (OAuthAccess)requestData.getProperty("com.openexchange.oauth.access");
        if (oAuthAccess == null) {
            return;
        }
        OAuthAction oAuthAction = action.getClass().getAnnotation(OAuthAction.class);
        String requiredScope = oAuthAction.value();
        if ("*".equals(requiredScope)) {
            return;
        }
        if ("__custom__".equals(requiredScope)) {
            for (Method method : action.getClass().getMethods()) {
                if (!method.isAnnotationPresent(OAuthScopeCheck.class)) continue;
                if (OAuthAnnotationProcessor.hasScopeCheckSignature(method)) {
                    try {
                        if (!((Boolean)method.invoke((Object)action, requestData, session, oAuthAccess)).booleanValue()) continue;
                        return;
                    }
                    catch (InvocationTargetException e) {
                        Throwable cause = e.getCause();
                        if (cause instanceof OXException) {
                            throw (OXException)cause;
                        }
                        throw new OXException(cause);
                    }
                    catch (IllegalAccessException | IllegalArgumentException e) {
                        LOG.error("Could not check scope", (Throwable)e);
                        throw new OXException((Throwable)e);
                    }
                }
                LOG.warn("Method '" + action.getClass() + "." + method.getName() + "' is annotated with @OAuthScopeCheck but its signature is invalid!");
            }
            throw new OAuthInsufficientScopeException();
        }
        if (!oAuthAccess.getScope().has(requiredScope)) {
            throw new OAuthInsufficientScopeException(requiredScope);
        }
    }

    private static boolean hasScopeCheckSignature(Method method) {
        Class<?>[] parameterTypes;
        if (Modifier.isPublic(method.getModifiers()) && method.getReturnType().isAssignableFrom(Boolean.TYPE) && (parameterTypes = method.getParameterTypes()).length == 3) {
            return parameterTypes[0].isAssignableFrom(AJAXRequestData.class) && parameterTypes[1].isAssignableFrom(ServerSession.class) && parameterTypes[2].isAssignableFrom(OAuthAccess.class);
        }
        return false;
    }
}

