/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler.converters;

import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.requesthandler.Converter;
import com.openexchange.ajax.requesthandler.ResultConverter;
import com.openexchange.exception.OXException;
import com.openexchange.tools.session.ServerSession;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class BasicTypeAPIResultConverter
implements ResultConverter {
    public static final List<ResultConverter> CONVERTERS = Collections.unmodifiableList(Arrays.asList(new BasicTypeAPIResultConverter("string"), new BasicTypeAPIResultConverter("int"), new BasicTypeAPIResultConverter("float"), new BasicTypeAPIResultConverter("boolean"), new BasicTypeAPIResultConverter("json")));
    private final String inputFormat;

    protected BasicTypeAPIResultConverter(String inputFormat) {
        this.inputFormat = inputFormat;
    }

    @Override
    public String getInputFormat() {
        return this.inputFormat;
    }

    @Override
    public String getOutputFormat() {
        return "apiResponse";
    }

    @Override
    public ResultConverter.Quality getQuality() {
        return ResultConverter.Quality.GOOD;
    }

    @Override
    public void convert(AJAXRequestData requestData, AJAXRequestResult result, ServerSession session, Converter converter) throws OXException {
        Collection<OXException> warnings;
        Response response = new Response(session);
        response.setData(result.getResultObject());
        response.setTimestamp(result.getTimestamp());
        response.setProperties(result.getResponseProperties());
        OXException exception = result.getException();
        if (null != exception) {
            response.setException(exception);
        }
        if (null != (warnings = result.getWarnings()) && !warnings.isEmpty()) {
            for (OXException warning : warnings) {
                response.addWarning(warning);
            }
        }
        result.setResultObject(response);
    }
}

