/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler;

import com.openexchange.ajax.requesthandler.AJAXActionService;
import com.openexchange.ajax.requesthandler.AJAXActionServiceFactory;
import com.openexchange.ajax.requesthandler.AJAXRequestDataTools;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.requesthandler.DispatcherNotes;
import com.openexchange.ajax.requesthandler.DispatcherServlet;
import com.openexchange.ajax.requesthandler.ETagAwareAJAXActionService;
import com.openexchange.ajax.requesthandler.LastModifiedAwareAJAXActionService;
import com.openexchange.annotation.Nullable;
import com.openexchange.dispatcher.DispatcherPrefixService;
import com.openexchange.exception.OXException;
import com.openexchange.java.Strings;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.http.HttpServletRequest;

public class Dispatchers {
    private static final AtomicReference<DispatcherPrefixService> DPS_REF = new AtomicReference();

    private Dispatchers() {
    }

    public static void signalDone(@Nullable AJAXRequestResult requestResult, Exception e) {
        if (null != requestResult) {
            requestResult.signalDone(e);
        }
    }

    public static String getActionFrom(HttpServletRequest req) {
        String action = req.getParameter("action");
        return null == action ? Strings.toUpperCase((CharSequence)req.getMethod()) : action;
    }

    public static boolean isApiOutputExpectedFor(HttpServletRequest req) {
        String prefix = Dispatchers.getPrefix();
        if (req.getRequestURI().startsWith(prefix)) {
            AJAXRequestDataTools requestDataTools = AJAXRequestDataTools.getInstance();
            String module = requestDataTools.getModule(prefix, req);
            AJAXActionServiceFactory factory = DispatcherServlet.getDispatcher().lookupFactory(module);
            if (factory != null) {
                return Dispatchers.isApiOutputExpectedFor(Dispatchers.optActionFor(requestDataTools.getAction(req), factory));
            }
        }
        return true;
    }

    public static String getPrefix() {
        DispatcherPrefixService dispatcherPrefixService = DPS_REF.get();
        if (dispatcherPrefixService == null) {
            throw new IllegalStateException(Dispatchers.class.getName() + " has not been initialized. DispatcherPrefixService is not set!");
        }
        return dispatcherPrefixService.getPrefix();
    }

    private static AJAXActionService optActionFor(String sAction, AJAXActionServiceFactory factory) {
        try {
            return factory.createActionService(sAction);
        }
        catch (OXException e) {
            return null;
        }
    }

    public static boolean isApiOutputExpectedFor(AJAXActionService action) {
        if (null == action) {
            return true;
        }
        if (action instanceof ETagAwareAJAXActionService || action instanceof LastModifiedAwareAJAXActionService) {
            return false;
        }
        DispatcherNotes dispatcherNotes = action.getClass().getAnnotation(DispatcherNotes.class);
        return null == dispatcherNotes || !"file".equals(dispatcherNotes.defaultFormat());
    }

    public static void setDispatcherPrefixService(DispatcherPrefixService service) {
        DPS_REF.set(service);
    }
}

