/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler;

import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.requesthandler.AJAXRequestResultPostProcessor;
import com.openexchange.ajax.requesthandler.DispatcherListener;
import java.util.Collection;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DispatcherListenerPostProcessor
implements AJAXRequestResultPostProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(DispatcherListenerPostProcessor.class);
    private final Collection<DispatcherListener> dispatcherListeners;

    public DispatcherListenerPostProcessor(Collection<DispatcherListener> dispatcherListeners) {
        this.dispatcherListeners = null == dispatcherListeners ? Collections.emptyList() : dispatcherListeners;
    }

    @Override
    public void doPostProcessing(AJAXRequestData requestData, AJAXRequestResult requestResult, Exception e) {
        for (DispatcherListener dispatcherListener : this.dispatcherListeners) {
            try {
                dispatcherListener.onResultReturned(requestData, requestResult, e);
            }
            catch (Exception x) {
                LOG.error("Failed to execute dispatcher listener {}", (Object)dispatcherListener.getClass().getSimpleName(), (Object)x);
            }
        }
    }
}

