/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler;

import com.openexchange.ajax.requesthandler.AJAXActionAnnotationProcessor;
import com.openexchange.ajax.requesthandler.AJAXActionCustomizer;
import com.openexchange.ajax.requesthandler.AJAXActionCustomizerFactory;
import com.openexchange.ajax.requesthandler.AJAXActionService;
import com.openexchange.ajax.requesthandler.AJAXActionServiceFactory;
import com.openexchange.ajax.requesthandler.AJAXExceptionHandler;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.requesthandler.AJAXState;
import com.openexchange.ajax.requesthandler.AJAXStateHandler;
import com.openexchange.ajax.requesthandler.CombinedActionFactory;
import com.openexchange.ajax.requesthandler.Dispatcher;
import com.openexchange.ajax.requesthandler.DispatcherListener;
import com.openexchange.ajax.requesthandler.DispatcherListenerPostProcessor;
import com.openexchange.ajax.requesthandler.DispatcherListenerRegistry;
import com.openexchange.ajax.requesthandler.DispatcherNotes;
import com.openexchange.ajax.requesthandler.ETagAwareAJAXActionService;
import com.openexchange.ajax.requesthandler.FlowControl;
import com.openexchange.ajax.requesthandler.LastModifiedAwareAJAXActionService;
import com.openexchange.ajax.requesthandler.Module;
import com.openexchange.continuation.Continuation;
import com.openexchange.continuation.ContinuationException;
import com.openexchange.continuation.ContinuationExceptionCodes;
import com.openexchange.continuation.ContinuationRegistryService;
import com.openexchange.continuation.ContinuationResponse;
import com.openexchange.exception.OXException;
import com.openexchange.framework.request.DefaultRequestContext;
import com.openexchange.framework.request.RequestContext;
import com.openexchange.framework.request.RequestContextHolder;
import com.openexchange.groupware.notify.hostname.HostData;
import com.openexchange.log.LogProperties;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.servlet.http.Tools;
import com.openexchange.tools.session.ServerSession;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDispatcher
implements Dispatcher {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultDispatcher.class);
    private final ConcurrentMap<StrPair, Boolean> fallbackSessionActionsCache = new ConcurrentHashMap<StrPair, Boolean>(128, 0.9f, 1);
    private final ConcurrentMap<StrPair, Boolean> publicSessionAuthCache = new ConcurrentHashMap<StrPair, Boolean>(128, 0.9f, 1);
    private final ConcurrentMap<StrPair, Boolean> omitSessionActionsCache = new ConcurrentHashMap<StrPair, Boolean>(128, 0.9f, 1);
    private final ConcurrentMap<StrPair, Boolean> noSecretCallbackCache = new ConcurrentHashMap<StrPair, Boolean>(128, 0.9f, 1);
    private final ConcurrentMap<String, AJAXActionServiceFactory> actionFactories = new ConcurrentHashMap<String, AJAXActionServiceFactory>(64, 0.9f, 1);
    private final Queue<AJAXActionCustomizerFactory> customizerFactories = new ConcurrentLinkedQueue<AJAXActionCustomizerFactory>();
    private final Queue<AJAXActionAnnotationProcessor> annotationProcessors = new ConcurrentLinkedQueue<AJAXActionAnnotationProcessor>();
    private final DispatcherListenerRegistry listenerRegistry;

    public DefaultDispatcher() {
        this(null);
    }

    public DefaultDispatcher(DispatcherListenerRegistry listenerRegistry) {
        this.listenerRegistry = null == listenerRegistry ? DispatcherListenerRegistry.NOOP_REGISTRY : listenerRegistry;
    }

    @Override
    public AJAXState begin() throws OXException {
        return new AJAXState();
    }

    @Override
    public void end(AJAXState state) {
        if (null != state) {
            state.close();
        }
    }

    @Override
    public boolean handles(String module) {
        return this.actionFactories.containsKey(module);
    }

    @Override
    public AJAXRequestResult perform(AJAXRequestData requestData, AJAXState state, ServerSession session) throws OXException {
        if (null == session) {
            throw AjaxExceptionCodes.MISSING_PARAMETER.create("session");
        }
        this.addLogProperties(requestData, false);
        List<AJAXActionCustomizer> customizers = this.determineCustomizers(requestData, session);
        try {
            List<DispatcherListener> dispatcherListeners;
            AJAXRequestResult result;
            AJAXRequestData modifiedRequestData = this.customizeRequest(requestData, customizers, session);
            RequestContextHolder.set((RequestContext)this.buildRequestContext(modifiedRequestData));
            AJAXActionServiceFactory factory = this.lookupFactory(modifiedRequestData.getModule());
            if (factory == null) {
                throw AjaxExceptionCodes.UNKNOWN_MODULE.create(modifiedRequestData.getModule());
            }
            AJAXActionService action = factory.createActionService(modifiedRequestData.getAction());
            if (action == null) {
                throw AjaxExceptionCodes.UNKNOWN_ACTION_IN_MODULE.create(modifiedRequestData.getAction(), modifiedRequestData.getModule());
            }
            AJAXRequestResult etagResult = this.checkResultNotModified(action, modifiedRequestData, session);
            if (etagResult != null) {
                AJAXRequestResult aJAXRequestResult = etagResult;
                return aJAXRequestResult;
            }
            AJAXRequestResult failedResult = this.checkRequestPreconditions(action, modifiedRequestData, session);
            if (failedResult != null) {
                AJAXRequestResult aJAXRequestResult = failedResult;
                return aJAXRequestResult;
            }
            for (AJAXActionAnnotationProcessor annotationProcessor : this.annotationProcessors) {
                if (!annotationProcessor.handles(action)) continue;
                annotationProcessor.process(action, modifiedRequestData, session);
            }
            if (factory instanceof AJAXStateHandler) {
                AJAXStateHandler handler = (AJAXStateHandler)((Object)factory);
                if (state.addInitializer(modifiedRequestData.getModule(), handler)) {
                    handler.initialize(state);
                }
            }
            modifiedRequestData.setState(state);
            if (requestData.getFormat() == null) {
                requestData.setFormat("apiResponse");
            }
            if (AJAXRequestResult.ResultType.DIRECT == (result = this.callAction(action, modifiedRequestData, dispatcherListeners = this.listenerRegistry.getDispatcherListenersFor(modifiedRequestData), session)).getType()) {
                AJAXRequestResult aJAXRequestResult = this.contributeDispatcherListeners(result, dispatcherListeners);
                return aJAXRequestResult;
            }
            result = this.customizeResult(modifiedRequestData, result, customizers, session);
            AJAXRequestResult aJAXRequestResult = this.contributeDispatcherListeners(result, dispatcherListeners);
            return aJAXRequestResult;
        }
        catch (OXException e) {
            for (AJAXActionCustomizer customizer : customizers) {
                if (!(customizer instanceof AJAXExceptionHandler)) continue;
                try {
                    ((AJAXExceptionHandler)((Object)customizer)).exceptionOccurred(requestData, e, session);
                }
                catch (Exception x) {}
            }
            throw e;
        }
        catch (RuntimeException e) {
            Throwable wrapped;
            if ("org.mozilla.javascript.WrappedException".equals(e.getClass().getName()) && (wrapped = e.getCause()) instanceof OXException) {
                throw (OXException)wrapped;
            }
            this.addLogProperties(requestData, true);
            throw AjaxExceptionCodes.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
        finally {
            RequestContextHolder.reset();
        }
    }

    private RequestContext buildRequestContext(AJAXRequestData requestData) throws OXException {
        HostData hostData = requestData.getHostData();
        if (hostData == null) {
            throw AjaxExceptionCodes.UNEXPECTED_ERROR.create("Host data was null. AJAX request data has not been initialized correctly!");
        }
        DefaultRequestContext context = new DefaultRequestContext();
        context.setHostData(hostData);
        return context;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AJAXRequestResult callAction(AJAXActionService action, AJAXRequestData requestData, List<DispatcherListener> optListeners, ServerSession session) throws OXException {
        AJAXRequestResult aJAXRequestResult;
        if (null == optListeners || optListeners.isEmpty()) {
            return this.doCallAction(action, requestData, session);
        }
        AJAXRequestResult result = null;
        Throwable exc = null;
        try {
            this.triggerOnRequestInitialized(requestData, optListeners);
            aJAXRequestResult = result = this.doCallAction(action, requestData, session);
        }
        catch (OXException e) {
            try {
                exc = e;
                throw e;
                catch (RuntimeException e2) {
                    exc = e2;
                    throw e2;
                }
            }
            catch (Throwable throwable) {
                this.triggerOnRequestPerformed(requestData, result, (Exception)exc, optListeners);
                throw throwable;
            }
        }
        this.triggerOnRequestPerformed(requestData, result, (Exception)exc, optListeners);
        return aJAXRequestResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AJAXRequestResult doCallAction(AJAXActionService action, AJAXRequestData requestData, ServerSession session) throws OXException {
        AJAXRequestResult result = null;
        try {
            result = action.perform(requestData, session);
            if (null == result) {
                this.addLogProperties(requestData, true);
                throw AjaxExceptionCodes.UNEXPECTED_RESULT.create(AJAXRequestResult.class.getSimpleName(), "null");
            }
        }
        catch (IllegalStateException e) {
            Throwable cause = e.getCause();
            if (cause instanceof OXException) {
                throw (OXException)cause;
            }
            throw AjaxExceptionCodes.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
        catch (ContinuationException e) {
            result = this.handleContinuationException(e, session);
        }
        finally {
            requestData.cleanUploads();
        }
        return result.setRequestData(requestData);
    }

    private AJAXRequestResult customizeResult(AJAXRequestData requestData, AJAXRequestResult result, List<AJAXActionCustomizer> customizers, ServerSession session) throws OXException {
        Collections.reverse(customizers);
        LinkedList<AJAXActionCustomizer> outgoing = new LinkedList<AJAXActionCustomizer>(customizers);
        AJAXRequestResult modifiedResult = result;
        while (!outgoing.isEmpty()) {
            Iterator iterator = outgoing.iterator();
            while (iterator.hasNext()) {
                AJAXActionCustomizer customizer = (AJAXActionCustomizer)iterator.next();
                try {
                    AJAXRequestResult modified = customizer.outgoing(requestData, modifiedResult, session);
                    if (modified != null && AJAXRequestResult.ResultType.DIRECT == (modifiedResult = modified).getType()) {
                        return modifiedResult;
                    }
                    iterator.remove();
                }
                catch (FlowControl.Later l) {}
            }
        }
        return modifiedResult;
    }

    private List<AJAXActionCustomizer> determineCustomizers(AJAXRequestData requestData, ServerSession session) {
        ArrayList<AJAXActionCustomizer> todo = new ArrayList<AJAXActionCustomizer>(4);
        for (AJAXActionCustomizerFactory customizerFactory : this.customizerFactories) {
            AJAXActionCustomizer customizer = customizerFactory.createCustomizer(requestData, session);
            if (customizer == null) continue;
            todo.add(customizer);
        }
        return todo;
    }

    private AJAXRequestData customizeRequest(AJAXRequestData requestData, List<AJAXActionCustomizer> customizers, ServerSession session) throws OXException {
        AJAXRequestData modifiedRequestData = requestData;
        ArrayList<AJAXActionCustomizer> outgoing = new ArrayList<AJAXActionCustomizer>(4);
        while (!customizers.isEmpty()) {
            Iterator<AJAXActionCustomizer> iterator = customizers.iterator();
            while (iterator.hasNext()) {
                AJAXActionCustomizer customizer = iterator.next();
                try {
                    AJAXRequestData modified = customizer.incoming(modifiedRequestData, session);
                    if (modified != null) {
                        modifiedRequestData = modified;
                    }
                    outgoing.add(customizer);
                    iterator.remove();
                }
                catch (FlowControl.Later l) {}
            }
        }
        customizers.clear();
        customizers.addAll(outgoing);
        return modifiedRequestData;
    }

    private AJAXRequestResult contributeDispatcherListeners(AJAXRequestResult requestResult, List<DispatcherListener> dispatcherListeners) {
        if (null != requestResult && null != dispatcherListeners) {
            requestResult.addPostProcessor(new DispatcherListenerPostProcessor(dispatcherListeners));
        }
        return requestResult;
    }

    private AJAXRequestResult checkRequestPreconditions(AJAXActionService action, AJAXRequestData requestData, ServerSession session) throws OXException {
        long ifUnmodifiedSince;
        String ifMatch = requestData.getHeader("If-Match");
        if (ifMatch != null && action instanceof ETagAwareAJAXActionService && ("*".equals(ifMatch) || ((ETagAwareAJAXActionService)action).checkETag(ifMatch, requestData, session))) {
            AJAXRequestResult failedResult = new AJAXRequestResult();
            failedResult.setHttpStatusCode(412);
            return failedResult;
        }
        if (action instanceof LastModifiedAwareAJAXActionService && (ifUnmodifiedSince = Tools.optHeaderDate(requestData.getHeader("If-Unmodified-Since"))) >= 0L && ((LastModifiedAwareAJAXActionService)action).checkLastModified(ifUnmodifiedSince + 1000L, requestData, session)) {
            AJAXRequestResult failedResult = new AJAXRequestResult();
            failedResult.setHttpStatusCode(412);
            return failedResult;
        }
        return null;
    }

    private AJAXRequestResult checkResultNotModified(AJAXActionService action, AJAXRequestData requestData, ServerSession session) throws OXException {
        long lastModified;
        String eTag = requestData.getETag();
        if (null != eTag && action instanceof ETagAwareAJAXActionService && ("*".equals(eTag) || ((ETagAwareAJAXActionService)action).checkETag(eTag, requestData, session))) {
            AJAXRequestResult etagResult = new AJAXRequestResult();
            etagResult.setType(AJAXRequestResult.ResultType.ETAG);
            long newExpires = requestData.getExpires();
            if (newExpires > 0L) {
                etagResult.setExpires(newExpires);
            }
            return etagResult;
        }
        if (null == eTag && action instanceof LastModifiedAwareAJAXActionService && (lastModified = requestData.getLastModified()) >= 0L && ((LastModifiedAwareAJAXActionService)action).checkLastModified(lastModified + 1000L, requestData, session)) {
            AJAXRequestResult etagResult = new AJAXRequestResult();
            etagResult.setType(AJAXRequestResult.ResultType.ETAG);
            long newExpires = requestData.getExpires();
            if (newExpires > 0L) {
                etagResult.setExpires(newExpires);
            }
            return etagResult;
        }
        return null;
    }

    private AJAXRequestResult handleContinuationException(ContinuationException e, ServerSession session) throws OXException {
        if (!ContinuationExceptionCodes.SCHEDULED_FOR_CONTINUATION.equals((OXException)((Object)e))) {
            throw e;
        }
        UUID uuid = e.getUuid();
        if (null == uuid) {
            throw e;
        }
        ContinuationRegistryService continuationRegistry = ServerServiceRegistry.getInstance().getService(ContinuationRegistryService.class);
        if (null == continuationRegistry) {
            throw e;
        }
        Continuation continuation = continuationRegistry.getContinuation(uuid, (Session)session);
        if (null == continuation) {
            throw e;
        }
        try {
            ContinuationResponse cr = continuation.getNextResponse(1000L, TimeUnit.NANOSECONDS);
            return new AJAXRequestResult(cr.getValue(), cr.getTimeStamp(), cr.getFormat()).setContinuationUuid(cr.isCompleted() ? null : uuid);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw AjaxExceptionCodes.UNEXPECTED_ERROR.create(ie, ie.getMessage());
        }
    }

    private void addLogProperties(AJAXRequestData requestData, boolean withQueryString) {
        if (null != requestData) {
            Map<String, String> parameters;
            LogProperties.putProperty((LogProperties.Name)LogProperties.Name.AJAX_ACTION, (Object)requestData.getAction());
            LogProperties.putProperty((LogProperties.Name)LogProperties.Name.AJAX_MODULE, (Object)requestData.getModule());
            if (withQueryString && null != (parameters = requestData.getParameters())) {
                StringBuilder sb = new StringBuilder(256);
                sb.append('\"');
                boolean first = true;
                for (Map.Entry<String, String> entry : parameters.entrySet()) {
                    if (first) {
                        sb.append('?');
                        first = false;
                    } else {
                        sb.append('&');
                    }
                    String value = LogProperties.getSanitizedValue((String)entry.getKey(), (String)entry.getValue());
                    sb.append(entry.getKey()).append('=').append(value);
                }
                sb.append('\"');
                LogProperties.putProperty((LogProperties.Name)LogProperties.Name.SERVLET_QUERY_STRING, (Object)sb.toString());
            }
        }
    }

    @Override
    public AJAXActionServiceFactory lookupFactory(String module) {
        int pos;
        AJAXActionServiceFactory serviceFactory = (AJAXActionServiceFactory)this.actionFactories.get(module);
        if (null == serviceFactory && (pos = module.indexOf(47)) > 0) {
            serviceFactory = (AJAXActionServiceFactory)this.actionFactories.get(module.substring(0, pos));
        }
        return serviceFactory;
    }

    private DispatcherNotes getActionMetadata(AJAXActionService action) {
        return null == action ? null : action.getClass().getAnnotation(DispatcherNotes.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(String module, AJAXActionServiceFactory factory) {
        ConcurrentMap<String, AJAXActionServiceFactory> concurrentMap = this.actionFactories;
        synchronized (concurrentMap) {
            AJAXActionServiceFactory current = this.actionFactories.putIfAbsent(module, factory);
            if (null != current) {
                try {
                    current = (AJAXActionServiceFactory)this.actionFactories.get(module);
                    Module moduleAnnotation = current.getClass().getAnnotation(Module.class);
                    if (null == moduleAnnotation) {
                        StringBuilder sb = new StringBuilder(512).append("There is already a factory associated with module \"");
                        sb.append(module).append("\": ").append(current.getClass().getName());
                        sb.append(". Therefore registration is denied for factory \"").append(factory.getClass().getName());
                        sb.append("\". Unless these two factories provide the \"").append(Module.class.getName()).append("\" annotation to specify what actions are supported by each factory.");
                        LOG.warn(sb.toString());
                    } else {
                        CombinedActionFactory combinedFactory;
                        if (current instanceof CombinedActionFactory) {
                            combinedFactory = (CombinedActionFactory)current;
                        } else {
                            combinedFactory = new CombinedActionFactory();
                            combinedFactory.add(current);
                            this.actionFactories.put(module, combinedFactory);
                        }
                        combinedFactory.add(factory);
                    }
                }
                catch (IllegalArgumentException e) {
                    LOG.error(e.getMessage());
                }
            }
        }
    }

    public void addCustomizer(AJAXActionCustomizerFactory factory) {
        this.customizerFactories.add(factory);
    }

    public void removeCustomizer(AJAXActionCustomizerFactory factory) {
        this.customizerFactories.remove(factory);
    }

    private void triggerOnRequestInitialized(AJAXRequestData requestData, List<DispatcherListener> dispatcherListeners) throws OXException {
        for (DispatcherListener dispatcherListener : dispatcherListeners) {
            dispatcherListener.onRequestInitialized(requestData);
        }
    }

    private void triggerOnRequestPerformed(AJAXRequestData requestData, AJAXRequestResult requestResult, Exception e, List<DispatcherListener> dispatcherListeners) throws OXException {
        for (DispatcherListener dispatcherListener : dispatcherListeners) {
            dispatcherListener.onRequestPerformed(requestData, requestResult, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String module, AJAXActionServiceFactory factory) {
        ConcurrentMap<String, AJAXActionServiceFactory> concurrentMap = this.actionFactories;
        synchronized (concurrentMap) {
            AJAXActionServiceFactory removed = (AJAXActionServiceFactory)this.actionFactories.remove(module);
            if (removed instanceof CombinedActionFactory) {
                CombinedActionFactory combinedFactory = (CombinedActionFactory)removed;
                combinedFactory.remove(factory);
                if (!combinedFactory.isEmpty()) {
                    this.actionFactories.put(module, combinedFactory);
                }
            }
        }
    }

    public void addAnnotationProcessor(AJAXActionAnnotationProcessor processor) {
        if (!this.annotationProcessors.contains(processor)) {
            this.annotationProcessors.add(processor);
        }
    }

    public void removeAnnotationProcessor(AJAXActionAnnotationProcessor processor) {
        this.annotationProcessors.remove(processor);
    }

    private AJAXActionService getActionServiceSafe(String action, AJAXActionServiceFactory factory) {
        try {
            return factory.createActionService(action);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public boolean mayUseFallbackSession(String module, String action) throws OXException {
        StrPair key = new StrPair(module, action);
        Boolean ret = (Boolean)this.fallbackSessionActionsCache.get(key);
        if (null == ret) {
            AJAXActionServiceFactory factory = this.lookupFactory(module);
            if (factory == null) {
                return false;
            }
            DispatcherNotes actionMetadata = this.getActionMetadata(this.getActionServiceSafe(action, factory));
            ret = actionMetadata == null ? Boolean.FALSE : Boolean.valueOf(actionMetadata.allowPublicSession());
            this.fallbackSessionActionsCache.put(key, ret);
        }
        return ret;
    }

    @Override
    public boolean mayPerformPublicSessionAuth(String module, String action) throws OXException {
        StrPair key = new StrPair(module, action);
        Boolean ret = (Boolean)this.publicSessionAuthCache.get(key);
        if (null == ret) {
            AJAXActionServiceFactory factory = this.lookupFactory(module);
            if (factory == null) {
                return false;
            }
            DispatcherNotes actionMetadata = this.getActionMetadata(this.getActionServiceSafe(action, factory));
            ret = actionMetadata == null ? Boolean.FALSE : Boolean.valueOf(actionMetadata.publicSessionAuth());
            this.publicSessionAuthCache.put(key, ret);
        }
        return ret;
    }

    @Override
    public boolean mayOmitSession(String module, String action) throws OXException {
        StrPair key = new StrPair(module, action);
        Boolean ret = (Boolean)this.omitSessionActionsCache.get(key);
        if (null == ret) {
            AJAXActionServiceFactory factory = this.lookupFactory(module);
            if (factory == null) {
                return false;
            }
            DispatcherNotes actionMetadata = this.getActionMetadata(this.getActionServiceSafe(action, factory));
            ret = actionMetadata == null ? Boolean.FALSE : Boolean.valueOf(actionMetadata.noSession());
            this.omitSessionActionsCache.put(key, ret);
        }
        return ret;
    }

    @Override
    public boolean noSecretCallback(String module, String action) throws OXException {
        StrPair key = new StrPair(module, action);
        Boolean ret = (Boolean)this.noSecretCallbackCache.get(key);
        if (null == ret) {
            DispatcherNotes actionMetadata;
            AJAXActionServiceFactory factory = this.lookupFactory(module);
            ret = factory == null ? Boolean.FALSE : ((actionMetadata = this.getActionMetadata(this.getActionServiceSafe(action, factory))) == null ? Boolean.FALSE : Boolean.valueOf(actionMetadata.noSecretCallback()));
            this.noSecretCallbackCache.put(key, ret);
        }
        return ret;
    }

    private static final class StrPair {
        private final String str1;
        private final String str2;
        private final int hash;

        StrPair(String str1, String str2) {
            this.str1 = str1;
            this.str2 = str2;
            int prime = 31;
            int result = 1;
            result = 31 * result + (str1 == null ? 0 : str1.hashCode());
            this.hash = result = 31 * result + (str2 == null ? 0 : str2.hashCode());
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof StrPair)) {
                return false;
            }
            StrPair other = (StrPair)obj;
            if (this.str1 == null ? other.str1 != null : !this.str1.equals(other.str1)) {
                return false;
            }
            return !(this.str2 == null ? other.str2 != null : !this.str2.equals(other.str2));
        }
    }
}

