/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler;

import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.tools.session.ServerSession;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AJAXRequestDataBuilder {
    private final AJAXRequestData data = new AJAXRequestData();
    private boolean formatSpecified = false;

    public static AJAXRequestDataBuilder request() {
        return new AJAXRequestDataBuilder();
    }

    private AJAXRequestDataBuilder() {
    }

    public AJAXRequestDataBuilder httpResources(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        this.data.setHttpServletRequest(httpRequest);
        this.data.setHttpServletResponse(httpResponse);
        return this;
    }

    public AJAXRequestDataBuilder session(ServerSession session) {
        this.data.setSession(session);
        return this;
    }

    public AJAXRequestDataBuilder module(String module) {
        this.data.setModule(module);
        return this;
    }

    public AJAXRequestDataBuilder action(String action) {
        this.data.setAction(action);
        this.data.putParameter("action", action);
        return this;
    }

    public AJAXRequestDataBuilder params(String ... params) {
        String name = null;
        for (String string : params) {
            if (name != null) {
                this.data.putParameter(name, string);
                name = null;
                continue;
            }
            name = string;
        }
        return this;
    }

    public AJAXRequestDataBuilder data(Object body, String format) {
        this.data.setData(body, format);
        return this;
    }

    public AJAXRequestDataBuilder format(String format) {
        this.formatSpecified = true;
        this.data.setFormat(format);
        return this;
    }

    public AJAXRequestDataBuilder pathInfo(String path) {
        this.data.setPathInfo(path);
        return this;
    }

    public AJAXRequestData build() {
        return this.build(null);
    }

    public AJAXRequestData build(AJAXRequestData original) {
        if (!this.formatSpecified) {
            this.format("native");
        }
        if (null != original) {
            this.data.setHostname(original.getHostname());
            this.data.setPrefix(original.getPrefix());
            this.data.setRoute(original.getRoute());
            this.data.setServerPort(original.getServerPort());
        }
        return this.data;
    }

    public AJAXRequestDataBuilder hostname(String hostname) {
        this.data.setHostname(hostname);
        return this;
    }
}

