/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.printing.converter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class NativeBuilder {
    private Stack<Object> stack;
    private Map<String, Object> currentMap;
    private List<Object> currentList;
    private Object current;
    private Object initial;
    private String key;

    public NativeBuilder list() {
        if (this.current != null) {
            this.stack.push(this.current);
        }
        ArrayList<Object> newList = new ArrayList<Object>();
        if (!this.isNil()) {
            this.value(newList);
        }
        this.currentList = newList;
        this.current = this.currentList;
        this.currentMap = null;
        if (this.initial == null) {
            this.initial = this.current;
        }
        return this;
    }

    public NativeBuilder map() {
        if (this.current != null) {
            this.stack.push(this.current);
        }
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        if (!this.isNil()) {
            this.value(newMap);
        }
        this.currentMap = newMap;
        this.current = this.currentMap;
        this.currentList = null;
        if (this.initial == null) {
            this.initial = this.current;
        }
        return this;
    }

    public NativeBuilder key(String key) {
        if (this.isNil()) {
            throw new IllegalStateException("Please start with either #map() or #list()");
        }
        if (this.isList()) {
            throw new IllegalStateException("Lists can only have values");
        }
        this.key = key;
        return this;
    }

    public NativeBuilder value(Object o) {
        if (this.isNil()) {
            throw new IllegalStateException("Please start with either #map() or #list()");
        }
        if (this.isList()) {
            this.currentList.add(o);
        } else {
            if (!this.hasKey()) {
                throw new IllegalStateException("Please provide a key for every value");
            }
            this.currentMap.put(this.key, o);
            this.key = null;
        }
        return this;
    }

    public NativeBuilder end() {
        if (this.stack.isEmpty()) {
            return this;
        }
        Object previous = this.stack.pop();
        this.current = null;
        if (Map.class.isInstance(previous)) {
            this.currentMap = (Map)previous;
            this.current = this.currentMap;
            this.currentList = null;
        }
        if (List.class.isInstance(previous)) {
            this.currentList = (List)previous;
            this.current = this.currentList;
            this.currentMap = null;
        }
        return this;
    }

    public Map<String, Object> getMap() {
        return (Map)this.initial;
    }

    public List getList() {
        return (List)this.initial;
    }

    private boolean isNil() {
        return this.current == null;
    }

    private boolean isList() {
        return this.currentList == null;
    }

    private boolean isMap() {
        return this.currentMap == null;
    }

    private boolean hasKey() {
        return this.key != null;
    }
}

