/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.helper;

import com.openexchange.ajax.helper.CombinedInputStream;
import com.openexchange.java.Streams;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicReference;

public class ImageUtils {
    private ImageUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isAnimatedGif(InputStream in) throws IOException {
        try {
            boolean bl = ImageUtils.isAnimatedGif(in, null);
            return bl;
        }
        finally {
            Streams.close((Closeable)in);
        }
    }

    public static boolean isAnimatedGif(InputStream in, AtomicReference<InputStream> newStreamRef) throws IOException {
        if (null == in) {
            return false;
        }
        ByteArrayOutputStream sink = null == newStreamRef ? null : new ByteArrayOutputStream(8192);
        int blen = 2048;
        byte[] buf = new byte[2048];
        int magic1 = 33;
        int magic2 = -7;
        int magic3 = 4;
        byte[] frameStart = new byte[]{33, -7, 4};
        int frames = 0;
        boolean eof = false;
        boolean first = true;
        boolean checkStartsWithMagic23 = false;
        boolean checkStartsWithMagic3 = false;
        while (!eof && frames <= 1) {
            int read = in.read(buf, 0, 2048);
            if (read <= 0) {
                eof = true;
                continue;
            }
            if (null != sink) {
                sink.write(buf, 0, read);
            }
            if (first) {
                if (71 != buf[0] || 73 != buf[1] || 70 != buf[2]) {
                    if (null != newStreamRef && null != sink) {
                        newStreamRef.set(new CombinedInputStream(sink.toByteArray(), in));
                    }
                    return false;
                }
                first = false;
            }
            int start = 0;
            if (checkStartsWithMagic3) {
                if (buf[0] == 4) {
                    ++frames;
                    start = 1;
                }
                checkStartsWithMagic3 = false;
            } else if (checkStartsWithMagic23) {
                if (buf[0] == -7 && buf[1] == 4) {
                    ++frames;
                    start = 2;
                }
                checkStartsWithMagic23 = false;
            }
            int pos = ImageUtils.indexOf(buf, frameStart, start, read);
            if (pos >= 0) {
                ++frames;
                do {
                    if ((pos = ImageUtils.indexOf(buf, frameStart, pos + 1, read)) >= 0) {
                        if (null != newStreamRef && null != sink) {
                            newStreamRef.set(new CombinedInputStream(sink.toByteArray(), in));
                        }
                        return true;
                    }
                    if (buf[read - 1] == 33) {
                        checkStartsWithMagic23 = true;
                        continue;
                    }
                    if (buf[read - 2] != 33 || buf[read - 1] != -7) continue;
                    checkStartsWithMagic3 = true;
                } while (pos >= 0);
                continue;
            }
            if (buf[read - 1] == 33) {
                checkStartsWithMagic23 = true;
                continue;
            }
            if (buf[read - 2] != 33 || buf[read - 1] != -7) continue;
            checkStartsWithMagic3 = true;
        }
        if (null != newStreamRef && null != sink) {
            newStreamRef.set(new CombinedInputStream(sink.toByteArray(), in));
        }
        return frames > 1;
    }

    private static int indexOf(byte[] data, byte[] pattern, int beginIndex, int endIndex) {
        if (beginIndex < 0 || beginIndex > data.length) {
            throw new IndexOutOfBoundsException(String.valueOf(beginIndex));
        }
        if (endIndex < 0 || endIndex > data.length) {
            throw new IndexOutOfBoundsException(String.valueOf(endIndex));
        }
        if (beginIndex > endIndex) {
            throw new IndexOutOfBoundsException(String.valueOf(endIndex - beginIndex));
        }
        int[] failure = ImageUtils.computeFailure(pattern);
        if (failure == null) {
            throw new IllegalArgumentException("pattern is null");
        }
        int j = 0;
        if (data.length == 0) {
            return -1;
        }
        for (int i = beginIndex; i < endIndex; ++i) {
            while (j > 0 && pattern[j] != data[i]) {
                j = failure[j - 1];
            }
            if (pattern[j] == data[i]) {
                ++j;
            }
            if (j != pattern.length) continue;
            return i - pattern.length + 1;
        }
        return -1;
    }

    private static int[] computeFailure(byte[] pattern) {
        if (pattern == null) {
            return null;
        }
        int[] failure = new int[pattern.length];
        int j = 0;
        for (int i = 1; i < pattern.length; ++i) {
            while (j > 0 && pattern[j] != pattern[i]) {
                j = failure[j - 1];
            }
            if (pattern[j] == pattern[i]) {
                // empty if block
            }
            failure[i] = ++j;
        }
        return failure;
    }
}

