/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.container;

import com.openexchange.ajax.fileholder.FileRandomAccess;
import com.openexchange.ajax.fileholder.IFileHolder;
import com.openexchange.configuration.ServerConfig;
import com.openexchange.exception.OXException;
import com.openexchange.log.LogProperties;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;

public final class TmpFileFileHolder
implements IFileHolder {
    private final File tmpFile = TmpFileFileHolder.newTempFile();
    private long length = -1L;
    private String contentType;
    private String name;
    private String disposition;
    private String delivery;
    private final List<Runnable> tasks = new LinkedList<Runnable>();
    private static volatile File uploadDirectory;

    public List<Runnable> getPostProcessingTasks() {
        return this.tasks;
    }

    public void addPostProcessingTask(Runnable task) {
        if (null != task) {
            this.tasks.add(task);
        }
    }

    public boolean repetitive() {
        return true;
    }

    public void close() throws IOException {
        this.tmpFile.delete();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public File getTmpFile() {
        return this.tmpFile;
    }

    public InputStream getStream() throws OXException {
        try {
            return new FileInputStream(this.tmpFile);
        }
        catch (IOException e) {
            throw AjaxExceptionCodes.IO_ERROR.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            throw AjaxExceptionCodes.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
    }

    public IFileHolder.RandomAccess getRandomAccess() throws OXException {
        try {
            return new FileRandomAccess(this.tmpFile);
        }
        catch (FileNotFoundException e) {
            throw AjaxExceptionCodes.IO_ERROR.create(e, e.getMessage());
        }
    }

    public long getLength() {
        return this.length;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getName() {
        return this.name;
    }

    public String getDisposition() {
        return this.disposition;
    }

    public void setLength(long length) {
        this.length = length;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDisposition(String disposition) {
        this.disposition = disposition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static File uploadDirectory() {
        File tmp = uploadDirectory;
        if (null != tmp) return tmp;
        Class<TmpFileFileHolder> clazz = TmpFileFileHolder.class;
        synchronized (TmpFileFileHolder.class) {
            tmp = uploadDirectory;
            if (null != tmp) return tmp;
            uploadDirectory = tmp = new File(ServerConfig.getProperty(ServerConfig.Property.UploadDirectory));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return tmp;
        }
    }

    public static File newTempFile() throws OXException {
        return TmpFileFileHolder.newTempFile(true);
    }

    public static File newTempFile(boolean autoManaged) throws OXException {
        try {
            File tmpFile = File.createTempFile("open-xchange-tmpfile-", ".tmp", TmpFileFileHolder.uploadDirectory());
            tmpFile.deleteOnExit();
            if (autoManaged) {
                LogProperties.addTempFile((File)tmpFile);
            }
            return tmpFile;
        }
        catch (IOException e) {
            throw AjaxExceptionCodes.IO_ERROR.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            throw AjaxExceptionCodes.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
    }

    public void setDelivery(String delivery) {
        this.delivery = delivery;
    }

    public String getDelivery() {
        return this.delivery;
    }
}

