/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.mime.processing;

import com.openexchange.html.HtmlService;
import com.openexchange.html.SimHtmlService;
import com.openexchange.i18n.tools.StringHelper;
import com.openexchange.java.Streams;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.mime.ContentType;
import com.openexchange.mail.mime.MimeDefaultSession;
import com.openexchange.mail.mime.converters.MimeMessageConverter;
import com.openexchange.mail.mime.processing.LocaleAndTimeZone;
import com.openexchange.mail.mime.processing.MimeReply;
import com.openexchange.mail.usersetting.UserSettingMail;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.sessiond.impl.SessionObject;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.internet.MimeMessage;
import junit.framework.TestCase;

public final class MimeReplyTest
extends TestCase {
    public void testForBug33061() {
        byte[] bytes = "Date: Tue, 10 Jun 2014 15:54:55 +0200 (CEST)\nFrom: aaa@open-xchange.com\nTo: bbb@open-xchange.com\nMessage-ID: <12345678>\nSubject: Blah\nMIME-Version: 1.0\nContent-Type: multipart/alternative; boundary=\"----=_Part_163_136634806.1402408495930\"\nX-Priority: 3\nImportance: Medium\nX-Mailer: Open-Xchange Mailer v7.6.0-Rev4\nX-Originating-Client: open-xchange-appsuite\n\n------=_Part_163_136634806.1402408495930\nMIME-Version: 1.0\nContent-Type: text/plain; charset=UTF-8\nContent-Transfer-Encoding: quoted-printable\n\nblah blah blah blah\n\n\n------=_Part_163_136634806.1402408495930\nContent-Type: multipart/related; \n    boundary=\"----=_Part_164_761165799.1402408495931\"\n\n------=_Part_164_761165799.1402408495931\nMIME-Version: 1.0\nContent-Type: text/html; charset=UTF-8\nContent-Transfer-Encoding: 7bit\n\n<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\"><html xmlns=\"http://www.w3.org/1999/xhtml\"><head>\n    <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />\n \n </head><body>\n \n  <p>blah blah blah blah</p>\n \n</body></html>\n------=_Part_164_761165799.1402408495931\nContent-Type: image/png; name=\"Screen Shot 2014-06-10 at 15.54.06.png\"\nContent-Transfer-Encoding: base64\nContent-ID: <e654a06fd06b4a6ea2788e79dd908b19@Open-Xchange>\nContent-Disposition: inline; filename=\"Screen Shot 2014-06-10 at\n 15.54.06.png\"\n\niVBORw0KGgoAAAANSUhEUgAABboAAAPgCAYAAAD0pMq/AAAYI2lDQ1BJQ0MgUHJvZmlsZQAAWIWV\neQdUFE2zds/OBliWJeeck+QMknPOGYEl55xRiSJBRRBQBFRQQVDBQBIxIUgQEVTAgEgwkFRQQBGQ\nOwR9v/+9/z333D5nZp6trqp5uqu6Z2oHADZmUnh4MIoagJDQ6EhrA21uRydnbtwYwAIUYALkgIzk\nFRWuZWlpCv7HtjIMoK3rc/EtX/+z3v+30Xj7RHkBAFki2NM7yisEwQ0AoFm9wiOjAcAMIHK+uOjw\nLbyEYPpIhCAAWLIt7LeD2bew5w6W2taxtdZBsC4AZAQSKdIPAOKWf+5YLz/EDzEc6aMN9Q4IRVQz\nEKzu5U/yBoC1A9HZExIStoUXECzs+R9+/P4fn55/fZJIfn/xzli2G5luQFR4MCnh/zgd/3sLCY75\ncw9e5CD4Rxpab40ZmbdLQWEmW5iA4LZQT3MLBNMiuDvAe1t/C7/2jzG029Wf94rSQeYMMAIk2N4k\nXRMEI3OJYowJstPaxTKkyG1bRB9lHhBtZLuLPSPDrHf9o2J9ovRs/mB/HyPTXZ9ZocHmf/AZ3wB9\nAhCAAAQgAAEIQAACEIAABCAAAQhAAAIQgAAEIAABCEAAAhCAAAQgAAEIQAACEIAABCAAAQhAAAIQ\ngAAEIAABCEAAAhCAAAQgAAEIQAACEIAABCAAAQhAAAIQgAAEIAABCEAAAhCAAAQgAAEIQAACEIDA\nQCPw/wNsHbPpztp8EAAAAABJRU5ErkJggg==\n------=_Part_164_761165799.1402408495931--\n\n------=_Part_163_136634806.1402408495930--\n".getBytes();
        try {
            javax.mail.Session mailSession = MimeDefaultSession.getDefaultSession();
            MimeMessage originalMessage = new MimeMessage(mailSession, (InputStream)Streams.newByteArrayInputStream((byte[])bytes));
            MailMessage mailMessage = MimeMessageConverter.convertMessage((MimeMessage)originalMessage);
            LinkedList list = new LinkedList();
            ContentType retvalContentType = new ContentType();
            Locale locale = Locale.US;
            LocaleAndTimeZone ltz = new LocaleAndTimeZone(locale, "Europe/Berlin");
            UserSettingMail usm = new UserSettingMail(17, 1337);
            usm.parseBits(381191);
            usm.setDisplayHtmlInlineContent(false);
            SessionObject session = new SessionObject("Bug31644");
            session.setContextId(1337);
            session.setUsername("17");
            ServerServiceRegistry.getInstance().addService(HtmlService.class, (Object)new SimHtmlService());
            MimeReply.generateReplyText((MailMessage)mailMessage, (ContentType)retvalContentType, (StringHelper)StringHelper.valueOf((Locale)locale), (LocaleAndTimeZone)ltz, (UserSettingMail)usm, (javax.mail.Session)mailSession, (Session)session, (int)0, list);
            MimeReplyTest.assertEquals((String)"Unexpected number of reply texts", (int)1, (int)list.size());
            StringBuilder replyTextBuilder = new StringBuilder(16384);
            for (int i = list.size() - 1; i >= 0; --i) {
                replyTextBuilder.append((String)list.get(i));
            }
            Pattern p = Pattern.compile(Pattern.quote("blah"));
            Matcher m = p.matcher(replyTextBuilder.toString());
            int cnt = 0;
            while (m.find()) {
                ++cnt;
            }
            MimeReplyTest.assertEquals((String)"Unexpected reply text", (int)4, (int)cnt);
        }
        catch (Exception e) {
            e.printStackTrace();
            MimeReplyTest.fail((String)e.getMessage());
        }
    }

    public void testForBug31644() {
        byte[] bytes = "From: asd@asd.de\nTo: dfg@dfg.com\nSubject: Subject\nDate: Tue, 18 Mar 2014 09:51:20 +0100\nMessage-ID: <07432353E3AC4F7C9924A69D2F04A4C4@de696630.foogroup.com>\nMIME-Version: 1.0\nContent-Type: multipart/mixed;\n    boundary=\"----=_NextPart_000_0005_01CF428F.A3C3FA00\"\nX-Mailer: Microsoft Office Outlook 11\nThread-Index: Ac9ChzuoyUyiFt75RLKVtS9ZgkIl0A==\n\nThis is a multi-part message in MIME format.\n\n------=_NextPart_000_0005_01CF428F.A3C3FA00\nContent-Type: text/plain;\n    charset=\"utf-8\"\nContent-Transfer-Encoding: quoted-printable\n\n             =20\nHallo Frau Barfoo,\n\nremoved for privacy\n\nMit freundlichen Gr=C3=BC=C3=9Fen\n=20\nJan Doe\nVerkauf Gro=C3=9Fkunden\n\nTel. 1111/123123-15\nFax 0265756/345543543-11\n=20\n=20\n\n=20\nAUTO ZENTRUM KAWASAKALALA\nNorbert Schlegelfegelhebel GmbH & Co KG\n\n=20\n=20\n\n\n------=_NextPart_000_0005_01CF428F.A3C3FA00\nContent-Type: image/jpeg;\n    name=\"P1010752.jpg\"\nContent-Transfer-Encoding: base64\nContent-Disposition: attachment;\n    filename=\"P1010752.jpg\"\n\n/9j/4AAQSkZJRgABAQEAYABgAAD/2wBDAAgGBgcGBQgHBwcJCQgKDBQNDAsLDBkSEw8UHRofHh0a\nKfU9aTjtRnj1oC9wzg5pDxQaaSSeuKYDjTT1xmjNGaNhMBkmpmbEeB6VEgywp8xwAKZlJ3aR/9k=\n\n------=_NextPart_000_0005_01CF428F.A3C3FA00\nContent-Type: image/jpeg;\n    name=\"P1010753.jpg\"\nContent-Transfer-Encoding: base64\nContent-Disposition: attachment;\n    filename=\"P1010753.jpg\"\n\n/9j/4AAQSkZJRgABAQEAYABgAAD/2wBDAAgGBgcGBQgHBwcJCQgKDBQNDAsLDBkSEw8UHRofHh0a\n4pFCnk9uKjl+Zs03fwBznpRYCUuCQo47UyUlBwc5poVh8xJ60x2J4OPxoGNDknrQxJOByaYcqM5H\n4U+JgTknmgD/2Q==\n\n------=_NextPart_000_0005_01CF428F.A3C3FA00\nContent-Type: image/jpeg;\n    name=\"P1010754.jpg\"\nContent-Transfer-Encoding: base64\nContent-Disposition: attachment;\n    filename=\"P1010754.jpg\"\n\n/9j/4AAQSkZJRgABAQEAYABgAAD/2wBDAAgGBgcGBQgHBwcJCQgKDBQNDAsLDBkSEw8UHRofHh0a\nkzSnA69KaMZwKBD1IxTSBkHtQSB0oBBGM0AMY/NSqSckkYoIGc5oCkjAB5oQm7AT2HNOWB3AODip\nreDOSTgj9KmknESADk00rGbk3ohI41gTLEAgVBNdk/KvA9qgllaRiSaiPAyTQ3oEYdWf/9k=\n\n------=_NextPart_000_0005_01CF428F.A3C3FA00\nContent-Type: image/jpeg;\n    name=\"P1010755.jpg\"\nContent-Transfer-Encoding: base64\nContent-Disposition: attachment;\n    filename=\"P1010755.jpg\"\n\n/9j/4AAQSkZJRgABAQEAYABgAAD/2wBDAAgGBgcGBQgHBwcJCQgKDBQNDAsLDBkSEw8UHRofHh0a\nEwJWIIweRioGyCQD+NSZHQd/Wo5BkAgYHpQtwEB96aT60A4HFJkA9etNhcUnAx1zSEjHJz+NBYEZ\npppMY4kDrSZB6k5zSE5xyPSkPBouFxSe/vzRjIPOQKbnJNNJJOc+9C0Ef//Z\n\n------=_NextPart_000_0005_01CF428F.A3C3FA00\nContent-Type: image/jpeg;\n    name=\"P1010756.jpg\"\nContent-Transfer-Encoding: base64\nContent-Disposition: attachment;\n    filename=\"P1010756.jpg\"\n\n/9j/4AAQSkZJRgABAQEAYABgAAD/2wBDAAgGBgcGBQgHBwcJCQgKDBQNDAsLDBkSEw8UHRofHh0a\nQxCNxz6GkOD607aTyDQFyPWk00IYMjkU8gEYzSAHOMd6CRTVxiEjHFIRxwPqaDnI/KlJz1JoAYQB\n69aFwTjNBPXHIoGOCCcUlcD/2Q==\n\n------=_NextPart_000_0005_01CF428F.A3C3FA00\nContent-Type: image/jpeg;\n    name=\"P1010757.jpg\"\nContent-Transfer-Encoding: base64\nContent-Disposition: attachment;\n    filename=\"P1010757.jpg\"\n\n/9j/4AAQSkZJRgABAQEAYABgAAD/2wBDAAgGBgcGBQgHBwcJCQgKDBQNDAsLDBkSEw8UHRofHh0a\nKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAoooo\nAKKKKACiiigD/9k=\n\n------=_NextPart_000_0005_01CF428F.A3C3FA00\nContent-Type: image/jpeg;\n    name=\"P1010758.jpg\"\nContent-Transfer-Encoding: base64\nContent-Disposition: attachment;\n    filename=\"P1010758.jpg\"\n\n/9j/4AAQSkZJRgABAQEAYABgAAD/2wBDAAgGBgcGBQgHBwcJCQgKDBQNDAsLDBkSEw8UHRofHh0a\nFMAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKK\nACiiigAooooAKKKKACiiigAooooAKKKKACiiigAopCwAqJpT0FAH/9k=\n\n------=_NextPart_000_0005_01CF428F.A3C3FA00\nContent-Type: multipart/alternative;\n    boundary=\"----=_NextPart_Avast_Info_Boundary\"\n\n------=_NextPart_Avast_Info_Boundary\nContent-Type: text/plain\nContent-Transfer-Encoding: quoted-printable\nContent-Description: avast info\n\n\n\n---\navast! Antivirus: Ausgehende Nachricht sauber.\nVirus-Datenbank (VPS): 140204-0, 04.02.2014\nGetestet am: 18.03.2014 09:51:33\navast! - copyright (c) 1988-2014 AVAST Software.\nhttp://www.avast.com\n\n\n\n\n------=_NextPart_Avast_Info_Boundary--\n\n------=_NextPart_000_0005_01CF428F.A3C3FA00--\n\n".getBytes();
        try {
            javax.mail.Session mailSession = MimeDefaultSession.getDefaultSession();
            MimeMessage originalMessage = new MimeMessage(mailSession, (InputStream)Streams.newByteArrayInputStream((byte[])bytes));
            MailMessage mailMessage = MimeMessageConverter.convertMessage((MimeMessage)originalMessage);
            LinkedList list = new LinkedList();
            ContentType retvalContentType = new ContentType();
            Locale locale = Locale.US;
            LocaleAndTimeZone ltz = new LocaleAndTimeZone(locale, "Europe/Berlin");
            UserSettingMail usm = new UserSettingMail(17, 1337);
            usm.parseBits(364807);
            SessionObject session = new SessionObject("Bug31644");
            session.setContextId(1337);
            session.setUsername("17");
            MimeReply.generateReplyText((MailMessage)mailMessage, (ContentType)retvalContentType, (StringHelper)StringHelper.valueOf((Locale)locale), (LocaleAndTimeZone)ltz, (UserSettingMail)usm, (javax.mail.Session)mailSession, (Session)session, (int)0, list);
            MimeReplyTest.assertEquals((String)"Unexpected number of reply texts", (int)1, (int)list.size());
            StringBuilder replyTextBuilder = new StringBuilder(16384);
            for (int i = list.size() - 1; i >= 0; --i) {
                replyTextBuilder.append((String)list.get(i));
            }
            MimeReplyTest.assertTrue((String)"Missing sub-text in composed reply text", (replyTextBuilder.indexOf("AUTO ZENTRUM") > 0 ? 1 : 0) != 0);
            MimeReplyTest.assertTrue((String)"Missing sub-text in composed reply text", (replyTextBuilder.indexOf("AVAST Software") > 0 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            MimeReplyTest.fail((String)e.getMessage());
        }
    }
}

