/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.mime;

import com.openexchange.mail.MailcapInitialization;
import com.openexchange.mail.mime.MimeDefaultSession;
import com.openexchange.mail.mime.MimeSmilFixer;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.mail.BodyPart;
import javax.mail.Multipart;
import javax.mail.internet.MimeMessage;
import junit.framework.TestCase;

public class MimeSmilFixerTest
extends TestCase {
    public void testFixSmil() {
        try {
            String src = "From: \"Mobile Inbound Agent\" incomingmessage@service-provider.com\nTo: someone@example.com\nSubject: This is a multimedia message (Open the message to view its content)\nDate: Mon, 7 Nov 2005 17:52:00 +0800\nContent-class: MS-OMS-MMS\nX-MS-Reply-to-mobile: +8613601391354\nMIME-Version: 1.0\nContent-Type: multipart/related; type=\"application/smil\"; boundary=\"------------Boundary=_thisisboundary\"\n\n--------------Boundary=_thisisboundary \nContent-Type: application/smil; name=\"mmspresent.smil\"\nContent-Location: \"mmspresent.smil\"\nContent-Transfer-Encoding: Base64\n\nPHNtaWw+... 1pbD4=\n--------------Boundary=_thisisboundary \nContent-Type: text/plain; name=\"textpart.txt\"\nContent-Transfer-Encoding: 7bit\nContent-Location: textpart.txt\n\nHello World!\n--------------Boundary=_thisisboundary \nContent-Type: image/gif; name=\"imagepart.gif\"\nContent-Transfer-Encoding: Base64\nContent-Location:imagepart.gif\n\nR0lGODlheABaAPf/...BDQi6j4uQAxwcixRzZErI5ROjfvSHJcmRMGBAAOw==\n--------------Boundary=_thisisboundary \nContent-Type: audio/mid; name=\"audiopart.mid\"\nContent-Transfer-Encoding: Base64\nContent-Location: audiopart.mid\n\nTVRoZAAAAAY...XBDfwA/fwA6f4dAOgAAPwAAQwAA/y8A\n--------------Boundary=_thisisboundary--";
            MailcapInitialization.getInstance().init();
            MimeMessage appleMimeMessage = new MimeMessage(MimeDefaultSession.getDefaultSession(), (InputStream)new ByteArrayInputStream(src.getBytes()));
            MimeMessage processed = MimeSmilFixer.getInstance().process(appleMimeMessage);
            MimeSmilFixerTest.assertTrue((String)"No multipart content", (boolean)(processed.getContent() instanceof Multipart));
            Multipart multipart = (Multipart)processed.getContent();
            MimeSmilFixerTest.assertTrue((String)"Unexpected Content-Type header.", (boolean)multipart.getContentType().startsWith("multipart/mixed"));
            int count = multipart.getCount();
            MimeSmilFixerTest.assertEquals((String)"Unexpected number of body parts.", (int)3, (int)count);
            BodyPart bodyPart = multipart.getBodyPart(0);
            MimeSmilFixerTest.assertTrue((String)"Unexpected Content-Type header.", (boolean)bodyPart.getContentType().startsWith("text/plain"));
        }
        catch (Exception e) {
            e.printStackTrace();
            MimeSmilFixerTest.fail((String)e.getMessage());
        }
    }
}

