/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.ldap;

import com.openexchange.groupware.ldap.AttributeValue;
import com.openexchange.groupware.ldap.RdbUserStorage;
import com.openexchange.groupware.ldap.UserAttribute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;

public class UserAttributeDiffTest {
    @Test
    public void testEmpty() {
        HashMap oldAttributes = new HashMap();
        HashMap newAttributes = new HashMap();
        HashMap<String, UserAttribute> added = new HashMap<String, UserAttribute>();
        HashMap<String, UserAttribute> removed = new HashMap<String, UserAttribute>();
        HashMap changed = new HashMap();
        RdbUserStorage.calculateDifferences(oldAttributes, newAttributes, added, removed, changed);
        Assert.assertTrue((boolean)oldAttributes.isEmpty());
        Assert.assertTrue((boolean)newAttributes.isEmpty());
        UserAttributeDiffTest.assertValues(added, UserAttributeDiffTest.N(new String[0]), UserAttributeDiffTest.MV(new UserAttribute[0]));
        UserAttributeDiffTest.assertValues(removed, UserAttributeDiffTest.N(new String[0]), UserAttributeDiffTest.MV(new UserAttribute[0]));
        Assert.assertTrue((boolean)changed.isEmpty());
    }

    @Test
    public void testAddedAttribute() {
        HashMap<String, UserAttribute> oldAttributes = new HashMap<String, UserAttribute>();
        HashMap<String, UserAttribute> newAttributes = new HashMap<String, UserAttribute>();
        HashMap<String, UserAttribute> added = new HashMap<String, UserAttribute>();
        HashMap<String, UserAttribute> removed = new HashMap<String, UserAttribute>();
        HashMap changed = new HashMap();
        oldAttributes.put("alias", UserAttributeDiffTest.V("alias", "marcus.klein@premium", "mk@premium"));
        newAttributes.putAll(oldAttributes);
        newAttributes.put("newKey", UserAttributeDiffTest.V("newKey", "newValue"));
        RdbUserStorage.calculateDifferences(oldAttributes, newAttributes, added, removed, changed);
        UserAttributeDiffTest.assertValues(added, UserAttributeDiffTest.N("newKey"), UserAttributeDiffTest.MV(UserAttributeDiffTest.V("newKey", "newValue")));
        UserAttributeDiffTest.assertValues(removed, UserAttributeDiffTest.N(new String[0]), UserAttributeDiffTest.MV(new UserAttribute[0]));
        Assert.assertTrue((boolean)changed.isEmpty());
    }

    @Test
    public void testChangedAttribute() {
        HashMap<String, UserAttribute> oldAttributes = new HashMap<String, UserAttribute>();
        HashMap<String, UserAttribute> newAttributes = new HashMap<String, UserAttribute>();
        HashMap<String, UserAttribute> added = new HashMap<String, UserAttribute>();
        HashMap<String, UserAttribute> removed = new HashMap<String, UserAttribute>();
        HashMap<String, UserAttribute> changed = new HashMap<String, UserAttribute>();
        oldAttributes.put("alias", UserAttributeDiffTest.V("alias", "marcus.klein@premium", "mk@premium"));
        String expectedOldValue = Long.toString(System.currentTimeMillis());
        oldAttributes.put("client:testClient", UserAttributeDiffTest.V("client:testClient", expectedOldValue));
        newAttributes.putAll(oldAttributes);
        String expectedNewValue = Long.toString(System.currentTimeMillis() + 1L);
        newAttributes.put("client:testClient", UserAttributeDiffTest.V("client:testClient", expectedNewValue));
        RdbUserStorage.calculateDifferences(oldAttributes, newAttributes, added, removed, changed);
        UserAttributeDiffTest.assertValues(added, UserAttributeDiffTest.N(new String[0]), UserAttributeDiffTest.MV(new UserAttribute[0]));
        UserAttributeDiffTest.assertValues(removed, UserAttributeDiffTest.N(new String[0]), UserAttributeDiffTest.MV(new UserAttribute[0]));
        UserAttributeDiffTest.assertChanges(changed, UserAttributeDiffTest.N("client:testClient"), UserAttributeDiffTest.MC(UserAttributeDiffTest.S(UserAttributeDiffTest.C(expectedOldValue, expectedNewValue))));
    }

    @Test
    public void testMultipleChangedValue() {
        HashMap<String, UserAttribute> oldAttributes = new HashMap<String, UserAttribute>();
        HashMap<String, UserAttribute> newAttributes = new HashMap<String, UserAttribute>();
        HashMap<String, UserAttribute> added = new HashMap<String, UserAttribute>();
        HashMap<String, UserAttribute> removed = new HashMap<String, UserAttribute>();
        HashMap<String, UserAttribute> changed = new HashMap<String, UserAttribute>();
        oldAttributes.put("alias", UserAttributeDiffTest.V("alias", "marcus.klein@premium", "mk@premium", "ma@premium"));
        newAttributes.put("alias", UserAttributeDiffTest.V("alias", "marcus.klein@premium", "mc@premium", "mr@premium"));
        RdbUserStorage.calculateDifferences(oldAttributes, newAttributes, added, removed, changed);
        UserAttributeDiffTest.assertValues(added, UserAttributeDiffTest.N(new String[0]), UserAttributeDiffTest.MV(new UserAttribute[0]));
        UserAttributeDiffTest.assertValues(removed, UserAttributeDiffTest.N(new String[0]), UserAttributeDiffTest.MV(new UserAttribute[0]));
        try {
            UserAttributeDiffTest.assertChanges(changed, UserAttributeDiffTest.N("alias"), UserAttributeDiffTest.MC(UserAttributeDiffTest.S(UserAttributeDiffTest.C("mk@premium", "mc@premium"), UserAttributeDiffTest.C("ma@premium", "mr@premium"))));
        }
        catch (AssertionError e) {
            UserAttributeDiffTest.assertChanges(changed, UserAttributeDiffTest.N("alias"), UserAttributeDiffTest.MC(UserAttributeDiffTest.S(UserAttributeDiffTest.C("mk@premium", "mr@premium"), UserAttributeDiffTest.C("ma@premium", "mc@premium"))));
        }
    }

    @Test
    public void testFakeMultipleChangedValue() {
        HashMap<String, UserAttribute> oldAttributes = new HashMap<String, UserAttribute>();
        HashMap<String, UserAttribute> newAttributes = new HashMap<String, UserAttribute>();
        HashMap<String, UserAttribute> added = new HashMap<String, UserAttribute>();
        HashMap<String, UserAttribute> removed = new HashMap<String, UserAttribute>();
        HashMap<String, UserAttribute> changed = new HashMap<String, UserAttribute>();
        oldAttributes.put("alias", UserAttributeDiffTest.V("alias", "marcus.klein@premium", "mk@premium", "ma@premium"));
        newAttributes.put("alias", UserAttributeDiffTest.V("alias", "marcus.klein@premium", "ma@premium", "mr@premium"));
        RdbUserStorage.calculateDifferences(oldAttributes, newAttributes, added, removed, changed);
        UserAttributeDiffTest.assertValues(added, UserAttributeDiffTest.N(new String[0]), UserAttributeDiffTest.MV(new UserAttribute[0]));
        UserAttributeDiffTest.assertValues(removed, UserAttributeDiffTest.N(new String[0]), UserAttributeDiffTest.MV(new UserAttribute[0]));
        UserAttributeDiffTest.assertChanges(changed, UserAttributeDiffTest.N("alias"), UserAttributeDiffTest.MC(UserAttributeDiffTest.S(UserAttributeDiffTest.C("mk@premium", "mr@premium"))));
    }

    private static void assertValues(Map<String, UserAttribute> added, String[] names, UserAttribute[] values) {
        Assert.assertEquals((long)names.length, (long)added.size());
        for (int i = 0; i < names.length; ++i) {
            Assert.assertTrue((boolean)added.containsKey(names[i]));
            Assert.assertEquals((Object)added.get(names[i]), (Object)values[i]);
        }
    }

    private static void assertChanges(Map<String, UserAttribute> changed, String[] names, Set<AttributeValue>[] sets) {
        Assert.assertEquals((long)names.length, (long)changed.size());
        for (int i = 0; i < names.length; ++i) {
            Assert.assertTrue((boolean)changed.containsKey(names[i]));
            Set actual = changed.get(names[i]).getValues();
            Set<AttributeValue> expected = sets[i];
            Assert.assertEquals((long)expected.size(), (long)actual.size());
            for (AttributeValue expectedChange : expected) {
                boolean found = false;
                for (AttributeValue actualChange : actual) {
                    if (!expectedChange.getValue().equals(actualChange.getValue()) || !expectedChange.getNewValue().equals(actualChange.getNewValue())) continue;
                    found = true;
                }
                Assert.assertTrue((boolean)found);
            }
        }
    }

    private static final UserAttribute V(String name, String ... values) {
        UserAttribute retval = new UserAttribute(name);
        for (String value : values) {
            retval.addValue(value);
        }
        return retval;
    }

    private static final AttributeValue C(String oldValue, String newValue) {
        return new AttributeValue(oldValue, null, newValue);
    }

    private static final Set<AttributeValue> S(AttributeValue ... changes) {
        HashSet<AttributeValue> retval = new HashSet<AttributeValue>();
        for (AttributeValue change : changes) {
            retval.add(change);
        }
        return retval;
    }

    private static final Set<AttributeValue>[] MC(Set<AttributeValue> ... changeSets) {
        return changeSets;
    }

    private static final String[] N(String ... keys) {
        return keys;
    }

    private static final UserAttribute[] MV(UserAttribute ... valueSets) {
        return valueSets;
    }
}

