/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler;

import com.openexchange.ajax.requesthandler.AJAXActionCustomizer;
import com.openexchange.ajax.requesthandler.AJAXActionCustomizerFactory;
import com.openexchange.ajax.requesthandler.AJAXActionService;
import com.openexchange.ajax.requesthandler.AJAXActionServiceFactory;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.requesthandler.DefaultDispatcher;
import com.openexchange.ajax.requesthandler.FlowControl;
import com.openexchange.exception.OXException;
import com.openexchange.tools.session.ServerSession;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import junit.framework.TestCase;

public class DefaultDispatcherTest
extends TestCase {
    public void testDispatchesToActionService() throws OXException {
        DefaultDispatcher dispatcher = new DefaultDispatcher();
        AJAXRequestResult res = new AJAXRequestResult();
        StaticActionService action = new StaticActionService(res);
        StaticActionFactory factory = new StaticActionFactory(action);
        dispatcher.register("someModule", (AJAXActionServiceFactory)factory);
        AJAXRequestData requestData = new AJAXRequestData();
        requestData.setModule("someModule");
        requestData.setAction("someAction");
        AJAXRequestResult receivedResult = dispatcher.perform(requestData, null, null);
        DefaultDispatcherTest.assertSame((Object)res, (Object)receivedResult);
    }

    public void testChain() throws OXException {
        DefaultDispatcher dispatcher = new DefaultDispatcher();
        AJAXRequestResult res = new AJAXRequestResult();
        StaticActionService action = new StaticActionService(res);
        StaticActionFactory factory = new StaticActionFactory(action);
        SimAJAXCustomizer c1 = new SimAJAXCustomizer("c1");
        SimAJAXCustomizer c2 = new SimAJAXCustomizer("c2");
        SimAJAXCustomizer c3 = new SimAJAXCustomizer("c3");
        dispatcher.addCustomizer((AJAXActionCustomizerFactory)new StaticAJAXCustomizerFactory(c1));
        dispatcher.addCustomizer((AJAXActionCustomizerFactory)new StaticAJAXCustomizerFactory(c2));
        dispatcher.addCustomizer((AJAXActionCustomizerFactory)new StaticAJAXCustomizerFactory(c3));
        dispatcher.register("someModule", (AJAXActionServiceFactory)factory);
        AJAXRequestData requestData = new AJAXRequestData();
        requestData.setModule("someModule");
        requestData.setAction("someAction");
        SimAJAXCustomizer.LOG.clear();
        AJAXRequestResult receivedResult = dispatcher.perform(requestData, null, null);
        DefaultDispatcherTest.assertSame((Object)res, (Object)receivedResult);
        DefaultDispatcherTest.assertSame((Object)requestData, (Object)c1.getRequest());
        DefaultDispatcherTest.assertSame((Object)requestData, (Object)c2.getRequest());
        DefaultDispatcherTest.assertSame((Object)requestData, (Object)c3.getRequest());
        DefaultDispatcherTest.assertSame((Object)res, (Object)c1.getResult());
        DefaultDispatcherTest.assertSame((Object)res, (Object)c2.getResult());
        DefaultDispatcherTest.assertSame((Object)res, (Object)c3.getResult());
        DefaultDispatcherTest.assertEquals(SimAJAXCustomizer.LOG, Arrays.asList("c1:incoming", "c2:incoming", "c3:incoming", "c3:outgoing", "c2:outgoing", "c1:outgoing"));
    }

    public void testLaterIncoming() throws OXException {
        DefaultDispatcher dispatcher = new DefaultDispatcher();
        AJAXRequestResult res = new AJAXRequestResult();
        StaticActionService action = new StaticActionService(res);
        StaticActionFactory factory = new StaticActionFactory(action);
        SimAJAXCustomizer c1 = new SimAJAXCustomizer("c1"){
            private boolean skipped;
            {
                this.skipped = false;
            }

            @Override
            public AJAXRequestData incoming(AJAXRequestData requestData, ServerSession session) throws OXException {
                if (!this.skipped) {
                    this.skipped = true;
                    throw new FlowControl.Later();
                }
                return super.incoming(requestData, session);
            }
        };
        SimAJAXCustomizer c2 = new SimAJAXCustomizer("c2");
        SimAJAXCustomizer c3 = new SimAJAXCustomizer("c3");
        dispatcher.addCustomizer((AJAXActionCustomizerFactory)new StaticAJAXCustomizerFactory(c1));
        dispatcher.addCustomizer((AJAXActionCustomizerFactory)new StaticAJAXCustomizerFactory(c2));
        dispatcher.addCustomizer((AJAXActionCustomizerFactory)new StaticAJAXCustomizerFactory(c3));
        dispatcher.register("someModule", (AJAXActionServiceFactory)factory);
        AJAXRequestData requestData = new AJAXRequestData();
        requestData.setModule("someModule");
        requestData.setAction("someAction");
        SimAJAXCustomizer.LOG.clear();
        dispatcher.perform(requestData, null, null);
        DefaultDispatcherTest.assertEquals(SimAJAXCustomizer.LOG, Arrays.asList("c2:incoming", "c3:incoming", "c1:incoming", "c1:outgoing", "c3:outgoing", "c2:outgoing"));
    }

    public void testLaterIncomingTwice() throws OXException {
        DefaultDispatcher dispatcher = new DefaultDispatcher();
        AJAXRequestResult res = new AJAXRequestResult();
        StaticActionService action = new StaticActionService(res);
        StaticActionFactory factory = new StaticActionFactory(action);
        SimAJAXCustomizer c1 = new SimAJAXCustomizer("c1"){
            private int skipCount;
            {
                this.skipCount = 0;
            }

            @Override
            public AJAXRequestData incoming(AJAXRequestData requestData, ServerSession session) throws OXException {
                if (this.skipCount < 2) {
                    ++this.skipCount;
                    throw new FlowControl.Later();
                }
                return super.incoming(requestData, session);
            }
        };
        SimAJAXCustomizer c2 = new SimAJAXCustomizer("c2");
        SimAJAXCustomizer c3 = new SimAJAXCustomizer("c3");
        dispatcher.addCustomizer((AJAXActionCustomizerFactory)new StaticAJAXCustomizerFactory(c1));
        dispatcher.addCustomizer((AJAXActionCustomizerFactory)new StaticAJAXCustomizerFactory(c2));
        dispatcher.addCustomizer((AJAXActionCustomizerFactory)new StaticAJAXCustomizerFactory(c3));
        dispatcher.register("someModule", (AJAXActionServiceFactory)factory);
        AJAXRequestData requestData = new AJAXRequestData();
        requestData.setModule("someModule");
        requestData.setAction("someAction");
        SimAJAXCustomizer.LOG.clear();
        dispatcher.perform(requestData, null, null);
        DefaultDispatcherTest.assertEquals(SimAJAXCustomizer.LOG, Arrays.asList("c2:incoming", "c3:incoming", "c1:incoming", "c1:outgoing", "c3:outgoing", "c2:outgoing"));
    }

    public void testLaterOutgoing() throws OXException {
        DefaultDispatcher dispatcher = new DefaultDispatcher();
        AJAXRequestResult res = new AJAXRequestResult();
        StaticActionService action = new StaticActionService(res);
        StaticActionFactory factory = new StaticActionFactory(action);
        SimAJAXCustomizer c1 = new SimAJAXCustomizer("c1");
        SimAJAXCustomizer c2 = new SimAJAXCustomizer("c2");
        SimAJAXCustomizer c3 = new SimAJAXCustomizer("c3"){
            private boolean skipped;
            {
                this.skipped = false;
            }

            @Override
            public AJAXRequestResult outgoing(AJAXRequestData requestData, AJAXRequestResult res, ServerSession session) throws OXException {
                if (!this.skipped) {
                    this.skipped = true;
                    throw new FlowControl.Later();
                }
                return super.outgoing(requestData, res, session);
            }
        };
        dispatcher.addCustomizer((AJAXActionCustomizerFactory)new StaticAJAXCustomizerFactory(c1));
        dispatcher.addCustomizer((AJAXActionCustomizerFactory)new StaticAJAXCustomizerFactory(c2));
        dispatcher.addCustomizer((AJAXActionCustomizerFactory)new StaticAJAXCustomizerFactory(c3));
        dispatcher.register("someModule", (AJAXActionServiceFactory)factory);
        AJAXRequestData requestData = new AJAXRequestData();
        requestData.setModule("someModule");
        requestData.setAction("someAction");
        SimAJAXCustomizer.LOG.clear();
        dispatcher.perform(requestData, null, null);
        DefaultDispatcherTest.assertEquals(SimAJAXCustomizer.LOG, Arrays.asList("c1:incoming", "c2:incoming", "c3:incoming", "c2:outgoing", "c1:outgoing", "c3:outgoing"));
    }

    public void testLaterOutgoingTwice() throws OXException {
        DefaultDispatcher dispatcher = new DefaultDispatcher();
        AJAXRequestResult res = new AJAXRequestResult();
        StaticActionService action = new StaticActionService(res);
        StaticActionFactory factory = new StaticActionFactory(action);
        SimAJAXCustomizer c1 = new SimAJAXCustomizer("c1");
        SimAJAXCustomizer c2 = new SimAJAXCustomizer("c2");
        SimAJAXCustomizer c3 = new SimAJAXCustomizer("c3"){
            private int skipCount;
            {
                this.skipCount = 0;
            }

            @Override
            public AJAXRequestResult outgoing(AJAXRequestData requestData, AJAXRequestResult res, ServerSession session) throws OXException {
                if (this.skipCount < 2) {
                    ++this.skipCount;
                    throw new FlowControl.Later();
                }
                return super.outgoing(requestData, res, session);
            }
        };
        dispatcher.addCustomizer((AJAXActionCustomizerFactory)new StaticAJAXCustomizerFactory(c1));
        dispatcher.addCustomizer((AJAXActionCustomizerFactory)new StaticAJAXCustomizerFactory(c2));
        dispatcher.addCustomizer((AJAXActionCustomizerFactory)new StaticAJAXCustomizerFactory(c3));
        dispatcher.register("someModule", (AJAXActionServiceFactory)factory);
        AJAXRequestData requestData = new AJAXRequestData();
        requestData.setModule("someModule");
        requestData.setAction("someAction");
        SimAJAXCustomizer.LOG.clear();
        dispatcher.perform(requestData, null, null);
        DefaultDispatcherTest.assertEquals(SimAJAXCustomizer.LOG, Arrays.asList("c1:incoming", "c2:incoming", "c3:incoming", "c2:outgoing", "c1:outgoing", "c3:outgoing"));
    }

    public void testUnknownModule() throws OXException {
        DefaultDispatcher dispatcher = new DefaultDispatcher();
        AJAXRequestData requestData = new AJAXRequestData();
        requestData.setModule("someModule");
        requestData.setAction("someAction");
        try {
            dispatcher.perform(requestData, null, null);
            DefaultDispatcherTest.fail((String)"Should have produced an OXException");
        }
        catch (OXException oXException) {
            // empty catch block
        }
    }

    public void testUnknownAction() throws OXException {
        DefaultDispatcher dispatcher = new DefaultDispatcher();
        StaticActionFactory factory = new StaticActionFactory(null);
        dispatcher.register("someModule", (AJAXActionServiceFactory)factory);
        AJAXRequestData requestData = new AJAXRequestData();
        requestData.setModule("someModule");
        requestData.setAction("someAction");
        try {
            dispatcher.perform(requestData, null, null);
            DefaultDispatcherTest.fail((String)"Should have produced an OXException");
        }
        catch (OXException oXException) {
            // empty catch block
        }
    }

    public void testNullCustomizer() throws OXException {
        DefaultDispatcher dispatcher = new DefaultDispatcher();
        AJAXRequestResult res = new AJAXRequestResult();
        StaticActionService action = new StaticActionService(res);
        StaticActionFactory factory = new StaticActionFactory(action);
        dispatcher.register("someModule", (AJAXActionServiceFactory)factory);
        dispatcher.addCustomizer((AJAXActionCustomizerFactory)new StaticAJAXCustomizerFactory(null));
        AJAXRequestData requestData = new AJAXRequestData();
        requestData.setModule("someModule");
        requestData.setAction("someAction");
        dispatcher.perform(requestData, null, null);
    }

    private static final class StaticActionFactory
    implements AJAXActionServiceFactory {
        private final AJAXActionService actionService;
        private String action;

        public StaticActionFactory(AJAXActionService actionService) {
            this.actionService = actionService;
        }

        public AJAXActionService createActionService(String action) throws OXException {
            this.action = action;
            return this.actionService;
        }

        public Collection<? extends AJAXActionService> getSupportedServices() {
            return Collections.singleton(this.actionService);
        }

        public String getAction() {
            return this.action;
        }
    }

    private static final class StaticActionService
    implements AJAXActionService {
        private final AJAXRequestResult result;
        private ServerSession session;
        private AJAXRequestData request;

        public StaticActionService(AJAXRequestResult result) {
            this.result = result;
        }

        public AJAXRequestResult perform(AJAXRequestData requestData, ServerSession session) throws OXException {
            this.request = requestData;
            this.session = session;
            return this.result;
        }

        public AJAXRequestData getRequest() {
            return this.request;
        }

        public ServerSession getSession() {
            return this.session;
        }
    }

    private static final class StaticAJAXCustomizerFactory
    implements AJAXActionCustomizerFactory {
        private final AJAXActionCustomizer customizer;

        public StaticAJAXCustomizerFactory(AJAXActionCustomizer customizer) {
            this.customizer = customizer;
        }

        public AJAXActionCustomizer createCustomizer(AJAXRequestData request, ServerSession session) {
            return this.customizer;
        }
    }

    private static class SimAJAXCustomizer
    implements AJAXActionCustomizer {
        public static List<String> LOG = new LinkedList<String>();
        private AJAXRequestData request;
        private AJAXRequestResult result;
        private final String name;

        private SimAJAXCustomizer(String name) {
            this.name = name;
        }

        public AJAXRequestData incoming(AJAXRequestData requestData, ServerSession session) throws OXException {
            this.request = requestData;
            LOG.add(this.name + ":incoming");
            return requestData;
        }

        public AJAXRequestResult outgoing(AJAXRequestData requestData, AJAXRequestResult result, ServerSession session) throws OXException {
            this.result = result;
            LOG.add(this.name + ":outgoing");
            return result;
        }

        public AJAXRequestData getRequest() {
            return this.request;
        }

        public AJAXRequestResult getResult() {
            return this.result;
        }
    }
}

