/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.publish.json;

import com.openexchange.datatypes.genericonf.DynamicFormDescription;
import com.openexchange.datatypes.genericonf.FormElement;
import com.openexchange.exception.OXException;
import com.openexchange.publish.Publication;
import com.openexchange.publish.PublicationTarget;
import com.openexchange.publish.PublicationTargetDiscoveryService;
import com.openexchange.publish.SimPublicationTargetDiscoveryService;
import com.openexchange.publish.json.PublicationParser;
import java.util.Map;
import junit.framework.TestCase;
import org.json.JSONException;
import org.json.JSONObject;

public class PublicationParserTest
extends TestCase {
    private JSONObject object;
    private SimPublicationTargetDiscoveryService discovery;
    private PublicationTarget target;

    protected void setUp() throws Exception {
        super.setUp();
        this.target = new PublicationTarget();
        this.target.setId("com.openexchange.publish.test");
        DynamicFormDescription form = new DynamicFormDescription();
        form.add(FormElement.input((String)"siteName", (String)"Site Name")).add(FormElement.checkbox((String)"protected", (String)"Protected"));
        this.target.setFormDescription(form);
        this.discovery = new SimPublicationTargetDiscoveryService();
        this.discovery.addTarget(this.target);
        this.object = new JSONObject();
        this.object.put("id", 12);
        JSONObject entity = new JSONObject();
        entity.put("id", 23);
        entity.put("folder", 42);
        this.object.put("entity", (Object)entity);
        this.object.put("entityModule", (Object)"oranges");
        this.object.put("target", (Object)"com.openexchange.publish.test");
        JSONObject config = new JSONObject();
        config.put("siteName", (Object)"publication");
        config.put("protected", true);
        this.object.put("com.openexchange.publish.test", (Object)config);
        this.object.put("enabled", false);
    }

    public void testParse() throws JSONException, OXException, OXException {
        PublicationParser publicationParser = new PublicationParser((PublicationTargetDiscoveryService)this.discovery);
        Publication publication = publicationParser.parse(this.object);
        PublicationParserTest.assertEquals((String)"id was wrong", (int)12, (int)publication.getId());
        PublicationParserTest.assertEquals((String)"entityId was wrong", (String)"42", (String)publication.getEntityId());
        PublicationParserTest.assertEquals((String)"entityModule was wrong", (String)"oranges", (String)publication.getModule());
        PublicationParserTest.assertNotNull((String)"target was null", (Object)publication.getTarget());
        PublicationParserTest.assertEquals((String)"wrong target", (Object)this.target, (Object)publication.getTarget());
        Map config = publication.getConfiguration();
        PublicationParserTest.assertNotNull((String)"config was null", (Object)config);
        PublicationParserTest.assertEquals((String)"siteName was wrong", (Object)"publication", config.get("siteName"));
        PublicationParserTest.assertEquals((String)"enabled was wrong", (boolean)true, (boolean)publication.containsEnabled());
        PublicationParserTest.assertEquals((String)"enabled was wrong", (boolean)false, (boolean)publication.isEnabled());
    }
}

