/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.osgi.util;

import com.openexchange.exception.OXException;
import com.openexchange.server.ServiceExceptionCode;
import java.util.concurrent.atomic.AtomicReference;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public class ServiceCallWrapper {
    static final AtomicReference<BundleContextProvider> BC_PROVIDER_REF = new AtomicReference<BundleContextProvider>(new BundleContextProvider());

    public static <S, T> T doServiceCall(Class<?> caller, Class<S> serviceClass, ServiceUser<S, T> serviceUser) throws ServiceException {
        BundleContextProvider bundleContextProvider = BC_PROVIDER_REF.get();
        if (null == bundleContextProvider) {
            throw new ServiceException("Service '" + serviceClass.getName() + "' is not available!", serviceClass);
        }
        BundleContext bundleContext = bundleContextProvider.getBundleContext(caller, serviceClass);
        ServiceReference serviceReference = bundleContext.getServiceReference(serviceClass);
        if (serviceReference == null) {
            throw new ServiceException("Service '" + serviceClass.getName() + "' is not available!", serviceClass);
        }
        try {
            Object service = bundleContext.getService(serviceReference);
            if (service == null) {
                throw new ServiceException("Service '" + serviceClass.getName() + "' is not available!", serviceClass);
            }
            T t = serviceUser.call(service);
            return t;
        }
        catch (Exception e) {
            throw new ServiceException(e, serviceClass);
        }
        finally {
            bundleContext.ungetService(serviceReference);
        }
    }

    public static <S, T> T tryServiceCall(Class<?> caller, Class<S> serviceClass, ServiceUser<S, T> serviceUser, T defaultValue) throws ServiceException {
        BundleContextProvider bundleContextProvider = BC_PROVIDER_REF.get();
        if (null == bundleContextProvider) {
            return defaultValue;
        }
        BundleContext bundleContext = bundleContextProvider.getBundleContext(caller, serviceClass);
        ServiceReference serviceReference = bundleContext.getServiceReference(serviceClass);
        if (serviceReference == null) {
            return defaultValue;
        }
        try {
            Object service = bundleContext.getService(serviceReference);
            if (service == null) {
                T t = defaultValue;
                return t;
            }
            T t = serviceUser.call(service);
            return t;
        }
        catch (Exception e) {
            throw new ServiceException(e, serviceClass);
        }
        finally {
            bundleContext.ungetService(serviceReference);
        }
    }

    static class BundleContextProvider {
        BundleContextProvider() {
        }

        BundleContext getBundleContext(Class<?> caller, Class<?> clazz) throws ServiceException {
            Bundle bundle = FrameworkUtil.getBundle(caller);
            if (bundle == null) {
                throw new ServiceException("Class '" + caller.getName() + "' was loaded outside from OSGi!", clazz);
            }
            BundleContext bundleContext = bundle.getBundleContext();
            if (bundleContext == null) {
                throw new ServiceException("No valid bundle context exists for bundle '" + bundle.getSymbolicName() + "'!", clazz);
            }
            return bundleContext;
        }
    }

    public static class ServiceException
    extends Exception {
        private static final long serialVersionUID = 4795091520600135899L;
        private final Class<?> serviceClass;
        private final boolean isServiceUnavailable;

        ServiceException(String message, Class<?> serviceClass) {
            super(message);
            this.serviceClass = serviceClass;
            this.isServiceUnavailable = true;
        }

        ServiceException(Throwable cause, Class<?> serviceClass) {
            super(cause);
            this.serviceClass = serviceClass;
            this.isServiceUnavailable = false;
        }

        public boolean isServiceUnavailable() {
            return this.isServiceUnavailable;
        }

        public OXException toOXException() {
            if (this.isServiceUnavailable) {
                return ServiceExceptionCode.SERVICE_UNAVAILABLE.create(new Object[]{this.serviceClass.getName()});
            }
            Throwable cause = this.getCause();
            if (cause instanceof OXException) {
                return (OXException)cause;
            }
            return new OXException(cause);
        }

        public RuntimeException toRuntimeException() {
            if (this.isServiceUnavailable) {
                return new RuntimeException("The required service " + this.serviceClass.getName() + " is temporary not available. Please try again later.");
            }
            return new RuntimeException(this.getCause());
        }
    }

    public static interface ServiceUser<S, T> {
        public T call(S var1) throws Exception;
    }
}

