/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.osgi.osgi;

import com.openexchange.exception.OXException;
import com.openexchange.management.ManagementService;
import com.openexchange.osgi.mbean.DeferredActivatorMBeanImpl;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ManagementRegisterer
implements ServiceTrackerCustomizer<ManagementService, ManagementService> {
    private final BundleContext context;
    private ObjectName objectName;

    ManagementRegisterer(BundleContext context) {
        this.context = context;
    }

    public ManagementService addingService(ServiceReference<ManagementService> reference) {
        ManagementService management = (ManagementService)this.context.getService(reference);
        this.registerOsgiMBean(management);
        return management;
    }

    public void modifiedService(ServiceReference<ManagementService> reference, ManagementService service) {
    }

    public void removedService(ServiceReference<ManagementService> reference, ManagementService service) {
        ManagementService management = service;
        this.unregisterOsgiMBean(management);
        this.context.ungetService(reference);
    }

    private void registerOsgiMBean(ManagementService management) {
        if (this.objectName == null) {
            Logger logger = LoggerFactory.getLogger(ManagementRegisterer.class);
            try {
                this.objectName = ManagementRegisterer.getObjectName(DeferredActivatorMBeanImpl.class.getName(), "com.openexchange.osgi");
                management.registerMBean(this.objectName, (Object)new DeferredActivatorMBeanImpl());
            }
            catch (MalformedObjectNameException e) {
                logger.error("", (Throwable)e);
            }
            catch (OXException e) {
                logger.error("", (Throwable)e);
            }
            catch (Exception e) {
                logger.error("", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterOsgiMBean(ManagementService management) {
        if (this.objectName != null) {
            Logger logger = LoggerFactory.getLogger(ManagementRegisterer.class);
            try {
                management.unregisterMBean(this.objectName);
            }
            catch (OXException e) {
                logger.error("", (Throwable)e);
            }
            finally {
                this.objectName = null;
            }
        }
    }

    private static ObjectName getObjectName(String className, String domain) throws MalformedObjectNameException {
        int pos = className.lastIndexOf(46);
        return new ObjectName(domain, "name", pos == -1 ? className : className.substring(pos + 1));
    }
}

