/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.osgi;

import com.openexchange.osgi.SimpleRegistryListener;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import javax.annotation.concurrent.ThreadSafe;
import org.osgi.framework.ServiceReference;

@ThreadSafe
public class ServiceSet<E>
implements NavigableSet<E>,
SimpleRegistryListener<E> {
    private final ConcurrentHashMap<E, Integer> serviceRankings;
    private final ConcurrentHashMap<E, Long> serviceIds;
    private final ConcurrentSkipListSet<E> entries;

    public ServiceSet() {
        final ConcurrentHashMap serviceRankings = new ConcurrentHashMap();
        this.serviceRankings = serviceRankings;
        final ConcurrentHashMap serviceIds = new ConcurrentHashMap();
        this.serviceIds = serviceIds;
        this.entries = new ConcurrentSkipListSet(new Comparator<E>(){

            @Override
            public int compare(E o1, E o2) {
                int result = this.getRanking(o1) - this.getRanking(o2);
                return 0 == result ? (int)(this.getServiceId(o1) - this.getServiceId(o2)) : result;
            }

            private int getRanking(E e) {
                Integer i = (Integer)serviceRankings.get(e);
                return null == i ? 0 : i;
            }

            private long getServiceId(E e) {
                Long l = (Long)serviceIds.get(e);
                return null == l ? 0L : l;
            }
        });
    }

    @Override
    public Comparator<? super E> comparator() {
        return this.entries.comparator();
    }

    @Override
    public E first() {
        return this.entries.first();
    }

    @Override
    public E last() {
        return this.entries.last();
    }

    @Override
    public boolean add(E arg0) {
        throw new UnsupportedOperationException("This set can only be modified by the backing service registry");
    }

    @Override
    public boolean addAll(Collection<? extends E> arg0) {
        throw new UnsupportedOperationException("This set can only be modified by the backing service registry");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("This set can only be modified by the backing service registry");
    }

    @Override
    public boolean contains(Object arg0) {
        return this.entries.contains(arg0);
    }

    @Override
    public boolean containsAll(Collection<?> arg0) {
        return this.entries.containsAll(arg0);
    }

    @Override
    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    @Override
    public boolean remove(Object arg0) {
        throw new UnsupportedOperationException("This set can only be modified by the backing service registry");
    }

    @Override
    public boolean removeAll(Collection<?> arg0) {
        throw new UnsupportedOperationException("This set can only be modified by the backing service registry");
    }

    @Override
    public boolean retainAll(Collection<?> arg0) {
        throw new UnsupportedOperationException("This set can only be modified by the backing service registry");
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    public Object[] toArray() {
        return this.entries.toArray();
    }

    @Override
    public <T> T[] toArray(T[] arg0) {
        return this.entries.toArray(arg0);
    }

    @Override
    public void added(ServiceReference<E> ref, E service) {
        Integer ranking = (Integer)ref.getProperty("service.ranking");
        if (ranking != null) {
            this.serviceRankings.put(service, ranking);
        }
        Long id = (Long)ref.getProperty("service.id");
        this.serviceIds.put(service, id);
        this.entries.add(service);
    }

    @Override
    public void removed(ServiceReference<E> ref, E service) {
        this.entries.remove(service);
        this.serviceRankings.remove(service);
        this.serviceIds.remove(service);
    }

    @Override
    public E ceiling(E arg0) {
        return this.entries.ceiling(arg0);
    }

    @Override
    public Iterator<E> descendingIterator() {
        return this.entries.descendingIterator();
    }

    @Override
    public NavigableSet<E> descendingSet() {
        return this.entries.descendingSet();
    }

    @Override
    public E floor(E arg0) {
        return this.entries.floor(arg0);
    }

    @Override
    public SortedSet<E> headSet(E arg0) {
        return this.entries.headSet((Object)arg0);
    }

    @Override
    public NavigableSet<E> headSet(E arg0, boolean arg1) {
        return this.entries.headSet(arg0, arg1);
    }

    @Override
    public E higher(E arg0) {
        return this.entries.higher(arg0);
    }

    @Override
    public Iterator<E> iterator() {
        return this.entries.iterator();
    }

    @Override
    public E lower(E arg0) {
        return this.entries.lower(arg0);
    }

    @Override
    public E pollFirst() {
        throw new UnsupportedOperationException("This set can only be modified by the backing service registry");
    }

    @Override
    public E pollLast() {
        throw new UnsupportedOperationException("This set can only be modified by the backing service registry");
    }

    @Override
    public SortedSet<E> subSet(E arg0, E arg1) {
        return this.entries.subSet((Object)arg0, (Object)arg1);
    }

    @Override
    public NavigableSet<E> subSet(E arg0, boolean arg1, E arg2, boolean arg3) {
        return this.entries.subSet(arg0, arg1, arg2, arg3);
    }

    @Override
    public SortedSet<E> tailSet(E arg0) {
        return this.entries.tailSet((Object)arg0);
    }

    @Override
    public NavigableSet<E> tailSet(E arg0, boolean arg1) {
        return this.entries.tailSet(arg0, arg1);
    }
}

