/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.messaging.generic;

import com.openexchange.exception.OXException;
import com.openexchange.messaging.MessagingField;
import com.openexchange.messaging.MessagingHeader;
import com.openexchange.messaging.MessagingMessage;
import com.openexchange.messaging.SimpleMessagingMessage;
import com.openexchange.messaging.StringMessageHeader;
import com.openexchange.messaging.generic.MessagingComparator;
import com.openexchange.messaging.generic.internet.MimeContentType;
import java.util.Date;
import java.util.Locale;
import javax.mail.internet.MailDateFormat;
import junit.framework.TestCase;

public class MessagingComparatorTest
extends TestCase {
    SimpleMessagingMessage msg1 = new SimpleMessagingMessage();
    SimpleMessagingMessage msg2 = new SimpleMessagingMessage();

    public void testByID() throws OXException {
        this.msg1.setId("a");
        this.msg2.setId("b");
        this.assertBigger(this.msg2, this.msg1, MessagingField.ID);
    }

    public void testByFolderId() throws OXException {
        this.msg1.setFolder("a");
        this.msg2.setFolder("b");
        this.assertBigger(this.msg2, this.msg1, MessagingField.FOLDER_ID);
    }

    public void testByContentType() throws OXException {
        this.msg1.putHeader((MessagingHeader)new MimeContentType("text/a"));
        this.msg2.putHeader((MessagingHeader)new MimeContentType("text/b"));
        this.assertBigger(this.msg2, this.msg1, MessagingField.CONTENT_TYPE);
    }

    public void testByFrom() throws OXException {
        this.msg1.putHeader((MessagingHeader)new StringMessageHeader("From", "a"));
        this.msg2.putHeader((MessagingHeader)new StringMessageHeader("From", "b"));
        this.assertBigger(this.msg2, this.msg1, MessagingField.FROM);
    }

    public void testByTo() throws OXException {
        this.msg1.putHeader((MessagingHeader)new StringMessageHeader("To", "a"));
        this.msg2.putHeader((MessagingHeader)new StringMessageHeader("To", "b"));
        this.assertBigger(this.msg2, this.msg1, MessagingField.TO);
    }

    public void testByBcc() throws OXException {
        this.msg1.putHeader((MessagingHeader)new StringMessageHeader("Bcc", "a"));
        this.msg2.putHeader((MessagingHeader)new StringMessageHeader("Bcc", "b"));
        this.assertBigger(this.msg2, this.msg1, MessagingField.BCC);
    }

    public void testByCc() throws OXException {
        this.msg1.putHeader((MessagingHeader)new StringMessageHeader("Cc", "a"));
        this.msg2.putHeader((MessagingHeader)new StringMessageHeader("Cc", "b"));
        this.assertBigger(this.msg2, this.msg1, MessagingField.CC);
    }

    public void testBySubject() throws OXException {
        this.msg1.putHeader((MessagingHeader)new StringMessageHeader("Subject", "a"));
        this.msg2.putHeader((MessagingHeader)new StringMessageHeader("Subject", "b"));
        this.assertBigger(this.msg2, this.msg1, MessagingField.SUBJECT);
    }

    public void testBySize() throws OXException {
        this.msg1.setSize(1L);
        this.msg2.setSize(3L);
        this.assertBigger(this.msg2, this.msg1, MessagingField.SIZE);
    }

    public void testSentDate() throws OXException {
        MailDateFormat dateFormat = new MailDateFormat();
        this.msg1.putHeader((MessagingHeader)new StringMessageHeader("Date", dateFormat.format(new Date(0L))));
        this.msg2.putHeader((MessagingHeader)new StringMessageHeader("Date", dateFormat.format(new Date())));
        this.assertBigger(this.msg2, this.msg1, MessagingField.SENT_DATE);
    }

    public void testReceivedDate() throws OXException {
        this.msg1.setReceivedDate(1L);
        this.msg2.setReceivedDate(3L);
        this.assertBigger(this.msg2, this.msg1, MessagingField.RECEIVED_DATE);
    }

    public void testFlags() throws OXException {
        this.msg1.setFlags(1);
        this.msg2.setFlags(3);
        this.assertBigger(this.msg2, this.msg1, MessagingField.FLAGS);
    }

    public void testThreadLevel() throws OXException {
        this.msg1.setThreadLevel(1);
        this.msg2.setThreadLevel(3);
        this.assertBigger(this.msg2, this.msg1, MessagingField.THREAD_LEVEL);
    }

    public void testDispositionNotificationTo() throws OXException {
        this.msg1.putHeader((MessagingHeader)new StringMessageHeader("Disposition-Notification-To", "a"));
        this.msg2.putHeader((MessagingHeader)new StringMessageHeader("Disposition-Notification-To", "b"));
        this.assertBigger(this.msg2, this.msg1, MessagingField.DISPOSITION_NOTIFICATION_TO);
    }

    public void testPriority() throws OXException {
        this.msg1.putHeader((MessagingHeader)new StringMessageHeader("X-Priority", "2"));
        this.msg2.putHeader((MessagingHeader)new StringMessageHeader("X-Priority", "100"));
        this.assertBigger(this.msg2, this.msg1, MessagingField.PRIORITY);
    }

    public void testColorLabel() throws OXException {
        this.msg1.setColorLabel(1);
        this.msg2.setColorLabel(3);
        this.assertBigger(this.msg2, this.msg1, MessagingField.COLOR_LABEL);
    }

    private void assertBigger(SimpleMessagingMessage bigger, SimpleMessagingMessage smaller, MessagingField field) throws OXException {
        MessagingComparator comparator = new MessagingComparator(field, Locale.ENGLISH);
        MessagingComparatorTest.assertTrue((String)("Comparison Failure in field " + field), (comparator.compare((MessagingMessage)bigger, (MessagingMessage)smaller) > 0 ? 1 : 0) != 0);
    }
}

