/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.java;

import com.openexchange.java.Stringer;
import com.openexchange.java.Strings;

public final class StringBuilderStringer
implements Stringer {
    private static final long serialVersionUID = -5617579874001869121L;
    private final StringBuilder sb;

    public StringBuilderStringer(StringBuilder sb) {
        this.sb = sb;
    }

    @Override
    public boolean isEmpty() {
        int length = this.sb.length();
        boolean empty = true;
        int i = length;
        while (empty && i-- > 0) {
            empty = Strings.isWhitespace(this.sb.charAt(i));
        }
        return empty;
    }

    @Override
    public int length() {
        return this.sb.length();
    }

    @Override
    public int capacity() {
        return this.sb.capacity();
    }

    @Override
    public void ensureCapacity(int minimumCapacity) {
        this.sb.ensureCapacity(minimumCapacity);
    }

    @Override
    public void trimToSize() {
        this.sb.trimToSize();
    }

    @Override
    public void setLength(int newLength) {
        this.sb.setLength(newLength);
    }

    @Override
    public Stringer append(Object obj) {
        this.sb.append(obj);
        return this;
    }

    @Override
    public Stringer append(String str) {
        this.sb.append(str);
        return this;
    }

    @Override
    public Stringer append(StringBuilder sb) {
        this.sb.append((CharSequence)sb);
        return this;
    }

    @Override
    public Stringer append(StringBuffer sb) {
        this.sb.append(sb);
        return this;
    }

    @Override
    public char charAt(int index) {
        return this.sb.charAt(index);
    }

    @Override
    public Stringer append(CharSequence s) {
        this.sb.append(s);
        return this;
    }

    @Override
    public int codePointAt(int index) {
        return this.sb.codePointAt(index);
    }

    @Override
    public Stringer append(CharSequence s, int start, int end) {
        this.sb.append(s, start, end);
        return this;
    }

    @Override
    public Stringer append(char[] str) {
        this.sb.append(str);
        return this;
    }

    @Override
    public Stringer append(char[] str, int offset, int len) {
        this.sb.append(str, offset, len);
        return this;
    }

    @Override
    public Stringer append(boolean b) {
        this.sb.append(b);
        return this;
    }

    @Override
    public Stringer append(char c) {
        this.sb.append(c);
        return this;
    }

    @Override
    public Stringer append(int i) {
        this.sb.append(i);
        return this;
    }

    @Override
    public int codePointBefore(int index) {
        return this.sb.codePointBefore(index);
    }

    @Override
    public Stringer append(long lng) {
        this.sb.append(lng);
        return this;
    }

    @Override
    public Stringer append(float f) {
        this.sb.append(f);
        return this;
    }

    @Override
    public Stringer append(double d) {
        this.sb.append(d);
        return this;
    }

    @Override
    public Stringer appendCodePoint(int codePoint) {
        this.sb.appendCodePoint(codePoint);
        return this;
    }

    @Override
    public Stringer delete(int start, int end) {
        this.sb.delete(start, end);
        return this;
    }

    @Override
    public Stringer deleteCharAt(int index) {
        this.sb.deleteCharAt(index);
        return this;
    }

    @Override
    public Stringer replace(int start, int end, String str) {
        this.sb.replace(start, end, str);
        return this;
    }

    @Override
    public int codePointCount(int beginIndex, int endIndex) {
        return this.sb.codePointCount(beginIndex, endIndex);
    }

    @Override
    public Stringer insert(int index, char[] str, int offset, int len) {
        this.sb.insert(index, str, offset, len);
        return this;
    }

    @Override
    public Stringer insert(int offset, Object obj) {
        this.sb.insert(offset, obj);
        return this;
    }

    @Override
    public Stringer insert(int offset, String str) {
        this.sb.insert(offset, str);
        return this;
    }

    @Override
    public Stringer insert(int offset, char[] str) {
        this.sb.insert(offset, str);
        return this;
    }

    @Override
    public Stringer insert(int dstOffset, CharSequence s) {
        this.sb.insert(dstOffset, s);
        return this;
    }

    @Override
    public int offsetByCodePoints(int index, int codePointOffset) {
        return this.sb.offsetByCodePoints(index, codePointOffset);
    }

    @Override
    public Stringer insert(int dstOffset, CharSequence s, int start, int end) {
        this.sb.insert(dstOffset, s, start, end);
        return this;
    }

    @Override
    public Stringer insert(int offset, boolean b) {
        this.sb.insert(offset, b);
        return this;
    }

    @Override
    public Stringer insert(int offset, char c) {
        this.sb.insert(offset, c);
        return this;
    }

    @Override
    public Stringer insert(int offset, int i) {
        this.sb.insert(offset, i);
        return this;
    }

    @Override
    public void getChars(int srcBegin, int srcEnd, char[] dst, int dstBegin) {
        this.sb.getChars(srcBegin, srcEnd, dst, dstBegin);
    }

    @Override
    public Stringer insert(int offset, long l) {
        this.sb.insert(offset, l);
        return this;
    }

    @Override
    public Stringer insert(int offset, float f) {
        this.sb.insert(offset, f);
        return this;
    }

    @Override
    public Stringer insert(int offset, double d) {
        this.sb.insert(offset, d);
        return this;
    }

    @Override
    public int indexOf(String str) {
        return this.sb.indexOf(str);
    }

    @Override
    public int indexOf(String str, int fromIndex) {
        return this.sb.indexOf(str, fromIndex);
    }

    @Override
    public int lastIndexOf(String str) {
        return this.sb.lastIndexOf(str);
    }

    @Override
    public int lastIndexOf(String str, int fromIndex) {
        return this.sb.lastIndexOf(str, fromIndex);
    }

    @Override
    public Stringer reverse() {
        this.sb.reverse();
        return this;
    }

    @Override
    public String toString() {
        return this.sb.toString();
    }

    @Override
    public void setCharAt(int index, char ch) {
        this.sb.setCharAt(index, ch);
    }

    @Override
    public String substring(int start) {
        return this.sb.substring(start);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.sb.subSequence(start, end);
    }

    @Override
    public String substring(int start, int end) {
        return this.sb.substring(start, end);
    }
}

