/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.java;

import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;

public class ConcurrentEnumMap<E extends Enum<E>, V>
implements Map<E, V> {
    private final AtomicReference<EnumMap<E, V>> ref;

    public ConcurrentEnumMap(Class<E> elementType) {
        this.ref = new AtomicReference<EnumMap<E, EnumMap<E, V>>>(new EnumMap(elementType));
    }

    @Override
    public boolean isEmpty() {
        return this.ref.get().isEmpty();
    }

    @Override
    public int size() {
        return this.ref.get().size();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.ref.get().containsValue(value);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.ref.get().containsKey(key);
    }

    @Override
    public V get(Object key) {
        return this.ref.get().get(key);
    }

    @Override
    public V put(E key, V value) {
        V added;
        EnumMap<E, V> map;
        EnumMap<E, V> expected;
        do {
            expected = this.ref.get();
            map = new EnumMap<E, V>(expected);
            added = map.put(key, value);
        } while (!this.ref.compareAndSet(expected, map));
        return added;
    }

    @Override
    public V putIfAbsent(E key, V value) {
        EnumMap<E, V> map;
        EnumMap<E, V> expected;
        do {
            V prev;
            if (null != (prev = (map = new EnumMap<E, V>(expected = this.ref.get())).get(key))) {
                return prev;
            }
            map.put(key, value);
        } while (!this.ref.compareAndSet(expected, map));
        return null;
    }

    @Override
    public V remove(Object key) {
        V removed;
        EnumMap<E, V> map;
        EnumMap<E, V> expected;
        do {
            expected = this.ref.get();
            map = new EnumMap<E, V>(expected);
            removed = map.remove(key);
        } while (!this.ref.compareAndSet(expected, map));
        return removed;
    }

    @Override
    public void putAll(Map<? extends E, ? extends V> m) {
        EnumMap<E, ? extends V> map;
        EnumMap<E, V> expected;
        do {
            expected = this.ref.get();
            map = new EnumMap<E, V>(expected);
            map.putAll(m);
        } while (!this.ref.compareAndSet(expected, map));
    }

    @Override
    public void clear() {
        this.ref.get().clear();
    }

    @Override
    public Set<E> keySet() {
        return this.ref.get().keySet();
    }

    @Override
    public Collection<V> values() {
        return this.ref.get().values();
    }

    @Override
    public Set<Map.Entry<E, V>> entrySet() {
        return this.ref.get().entrySet();
    }
}

