/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.session.reservation;

import com.openexchange.authentication.Authenticated;
import com.openexchange.authentication.Cookie;
import com.openexchange.authentication.Header;
import com.openexchange.authentication.ResponseEnhancement;
import com.openexchange.authentication.ResultCode;
import com.openexchange.authentication.SessionEnhancement;
import com.openexchange.session.Session;
import java.util.LinkedList;
import java.util.List;

public class EnhancedAuthenticated
implements Authenticated,
ResponseEnhancement,
SessionEnhancement {
    private final List<Header> headers = new LinkedList<Header>();
    private final List<Cookie> cookies = new LinkedList<Cookie>();
    private final Authenticated delegate;
    private ResultCode code;
    private String redirect;

    public EnhancedAuthenticated(Authenticated delegate) {
        this.delegate = delegate;
        if (delegate instanceof ResponseEnhancement) {
            Header[] delegateHeaders;
            ResponseEnhancement re = (ResponseEnhancement)((Object)delegate);
            Cookie[] delegateCookies = re.getCookies();
            if (delegateCookies != null && delegateCookies.length > 0) {
                for (Cookie cookie : delegateCookies) {
                    this.addCookie(cookie);
                }
            }
            if ((delegateHeaders = re.getHeaders()) != null && delegateHeaders.length > 0) {
                for (Header header : delegateHeaders) {
                    this.addHeader(header);
                }
            }
        }
    }

    public void setResultCode(ResultCode code) {
        this.code = code;
    }

    public void setRedirect(String redirect) {
        this.redirect = redirect;
    }

    public void addCookie(Cookie cookie) {
        this.cookies.add(cookie);
    }

    public void addHeader(Header header) {
        this.headers.add(header);
    }

    protected void doEnhanceSession(Session session) {
    }

    @Override
    public void enhanceSession(Session session) {
        if (this.delegate instanceof SessionEnhancement) {
            ((SessionEnhancement)((Object)this.delegate)).enhanceSession(session);
        }
        this.doEnhanceSession(session);
    }

    @Override
    public ResultCode getCode() {
        ResultCode delegateCode;
        if (this.code != null) {
            return this.code;
        }
        if (this.delegate instanceof ResponseEnhancement && (delegateCode = ((ResponseEnhancement)((Object)this.delegate)).getCode()) != null && delegateCode != ResultCode.SUCCEEDED) {
            return delegateCode;
        }
        return ResultCode.SUCCEEDED;
    }

    @Override
    public Header[] getHeaders() {
        return this.headers.toArray(new Header[this.headers.size()]);
    }

    @Override
    public Cookie[] getCookies() {
        return this.cookies.toArray(new Cookie[this.cookies.size()]);
    }

    @Override
    public String getRedirect() {
        if (this.redirect != null) {
            return this.redirect;
        }
        if (this.delegate instanceof ResponseEnhancement) {
            return ((ResponseEnhancement)((Object)this.delegate)).getRedirect();
        }
        return null;
    }

    @Override
    public String getContextInfo() {
        return this.delegate.getContextInfo();
    }

    @Override
    public String getUserInfo() {
        return this.delegate.getUserInfo();
    }
}

