/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.i18n;

import com.openexchange.i18n.I18nService;
import com.openexchange.i18n.Translator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class I18nTranslator
implements Translator {
    private static final Logger LOG = LoggerFactory.getLogger(I18nTranslator.class);
    private final I18nService service;

    public I18nTranslator(I18nService service) {
        this.service = service;
    }

    @Override
    public String translate(String toTranslate) {
        if (!this.service.hasKey(toTranslate)) {
            LOG.debug("I18n service for locale {} has no translation for \"{}\".", (Object)this.service.getLocale(), (Object)toTranslate);
            return toTranslate;
        }
        return this.service.getLocalized(toTranslate);
    }
}

