/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.results;

import java.util.LinkedList;
import java.util.List;

public class CollectionDelta<T> {
    private final List<T> newAndModified;
    private final List<T> deleted;

    public CollectionDelta() {
        this.newAndModified = new LinkedList<T>();
        this.deleted = new LinkedList<T>();
    }

    public CollectionDelta(List<T> newAndModified, List<T> deleted) {
        this.newAndModified = newAndModified;
        this.deleted = deleted;
    }

    public CollectionDelta<T> addNewOrModified(T thing) {
        this.newAndModified.add(thing);
        return this;
    }

    public CollectionDelta<T> addDeleted(T thing) {
        this.deleted.add(thing);
        return this;
    }

    public List<T> getNewAndModified() {
        return this.newAndModified;
    }

    public List<T> getDeleted() {
        return this.deleted;
    }

    public void visitAll(DeltaVisitor<T> visitor) {
        for (T thing : this.newAndModified) {
            visitor.newOrModified(thing);
        }
        for (T thing : this.deleted) {
            visitor.deleted(thing);
        }
    }

    public static interface DeltaVisitor<T> {
        public void newOrModified(T var1);

        public void deleted(T var1);
    }
}

