/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.exception;

import com.openexchange.java.Strings;
import com.openexchange.java.util.Pair;
import com.openexchange.log.LogProperties;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptionUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ExceptionUtils.class);
    private static final String MARKER = " ---=== /!\\ ===--- ";

    public static void handleThrowable(Throwable t) {
        if (t instanceof ThreadDeath) {
            ExceptionUtils.logError("Thread death", t);
            throw (ThreadDeath)t;
        }
        if (t instanceof OutOfMemoryError) {
            OutOfMemoryError oom = (OutOfMemoryError)t;
            ExceptionUtils.handleOOM(oom);
            throw oom;
        }
        if (t instanceof VirtualMachineError) {
            ExceptionUtils.logVirtualMachineError(t);
            throw (VirtualMachineError)t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handleOOM(OutOfMemoryError oom) {
        block16: {
            String message = oom.getMessage();
            if ("unable to create new native thread".equalsIgnoreCase(message)) {
                if (!Boolean.TRUE.equals(System.getProperties().get("__thread_dump_created"))) {
                    System.getProperties().put("__thread_dump_created", Boolean.TRUE);
                    boolean error = true;
                    try {
                        StringBuilder sb = new StringBuilder(2048);
                        Map<Thread, StackTraceElement[]> threads = Thread.getAllStackTraces();
                        String ls = Strings.getLineSeparator();
                        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss,SSSZ", Locale.US);
                        String date = dateFormat.format(new Date());
                        sb.append("------ BEGIN THREAD DUMP (").append(date).append(", ").append(threads.size()).append(" threads) ------").append(ls);
                        for (Map.Entry<Thread, StackTraceElement[]> mapEntry : threads.entrySet()) {
                            Thread thread = mapEntry.getKey();
                            sb.append(thread).append(": ").append(thread.getState().name()).append(ls);
                            for (StackTraceElement elem : mapEntry.getValue()) {
                                sb.append('\t').append(elem).append(ls);
                            }
                        }
                        sb.append("------ END THREAD DUMP (").append(date).append(", ").append(threads.size()).append(" threads) ------").append(ls);
                        System.err.print(sb.toString());
                        sb.setLength(0);
                        sb = null;
                        LOG.info("{}    Thread dump written to stderr{}", (Object)ls, (Object)ls);
                        error = false;
                    }
                    finally {
                        if (error) {
                            System.getProperties().remove("__thread_dump_created");
                        }
                    }
                }
            } else if ("Java heap space".equalsIgnoreCase(message)) {
                try {
                    MBeanServer server = ManagementFactory.getPlatformMBeanServer();
                    Pair<Boolean, String> heapDumpArgs = ExceptionUtils.checkHeapDumpArguments();
                    if (((Boolean)heapDumpArgs.getFirst()).booleanValue() || Boolean.TRUE.equals(System.getProperties().get("__heap_dump_created"))) break block16;
                    System.getProperties().put("__heap_dump_created", Boolean.TRUE);
                    boolean error = true;
                    try {
                        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd-hh:mm:ss", Locale.US);
                        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
                        String path = null == heapDumpArgs.getSecond() ? "/tmp" : (String)heapDumpArgs.getSecond();
                        String fn = path + "/" + dateFormat.format(new Date()) + "-heap.hprof";
                        String mbeanName = "com.sun.management:type=HotSpotDiagnostic";
                        server.invoke(new ObjectName(mbeanName), "dumpHeap", new Object[]{fn, Boolean.TRUE}, new String[]{String.class.getCanonicalName(), "boolean"});
                        LOG.info("{}    Heap snapshot dumped to file {}{}", new Object[]{Strings.getLineSeparator(), fn, Strings.getLineSeparator()});
                        error = false;
                    }
                    finally {
                        if (error) {
                            System.getProperties().remove("__heap_dump_created");
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        ExceptionUtils.logVirtualMachineError(oom);
    }

    private static void logVirtualMachineError(Throwable t) {
        ExceptionUtils.logError("The Java Virtual Machine is broken or has run out of resources necessary for it to continue operating.", t);
    }

    private static void logError(String message, Throwable t) {
        Map<String, String> taskProperties = LogProperties.getPropertyMap();
        if (null == taskProperties) {
            LOG.error("{}{}{}", new Object[]{MARKER, message, MARKER, t});
        } else {
            StringBuilder logBuilder = new StringBuilder(512);
            TreeMap<String, String> sorted = new TreeMap<String, String>();
            for (Map.Entry<String, String> entry : taskProperties.entrySet()) {
                String propertyName = entry.getKey();
                String value = entry.getValue();
                if (null == value) continue;
                sorted.put(propertyName, value);
            }
            for (Map.Entry<String, String> entry : sorted.entrySet()) {
                logBuilder.append(Strings.getLineSeparator()).append(entry.getKey()).append('=').append(entry.getValue());
            }
            logBuilder.deleteCharAt(0);
            logBuilder.append(Strings.getLineSeparator()).append(Strings.getLineSeparator());
            logBuilder.append(MARKER);
            logBuilder.append(message);
            logBuilder.append(MARKER);
            LOG.error(logBuilder.toString(), t);
        }
    }

    private static Pair<Boolean, String> checkHeapDumpArguments() {
        RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
        List<String> arguments = runtimeMxBean.getInputArguments();
        boolean heapDumpOnOOm = false;
        String path = null;
        for (String argument : arguments) {
            File file;
            if ("-XX:+HeapDumpOnOutOfMemoryError".equals(argument)) {
                heapDumpOnOOm = true;
                continue;
            }
            if (!argument.startsWith("-XX:HeapDumpPath=") || (file = new File(path = argument.substring(17).trim())).exists() && file.canWrite()) continue;
            path = null;
        }
        return new Pair((Object)heapDumpOnOOm, path);
    }
}

