/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.fileholder;

import com.openexchange.ajax.fileholder.Readable;
import java.io.IOException;

public class PushbackReadable
implements Readable {
    private Readable readable;
    private byte[] buf;
    private int pos;

    public PushbackReadable(Readable readable) {
        this(readable, 1);
    }

    public PushbackReadable(Readable readable, int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("size <= 0");
        }
        this.readable = readable;
        this.buf = new byte[size];
        this.pos = size;
    }

    private void ensureOpen() throws IOException {
        if (this.readable == null) {
            throw new IOException("Readable closed");
        }
    }

    @Override
    public void close() throws IOException {
        if (this.readable == null) {
            return;
        }
        this.readable.close();
        this.readable = null;
        this.buf = null;
    }

    @Override
    public int read(byte[] b) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int offset, int length) throws IOException {
        this.ensureOpen();
        if (b == null) {
            throw new NullPointerException();
        }
        if (offset < 0 || length < 0 || length > b.length - offset) {
            throw new IndexOutOfBoundsException();
        }
        if (length == 0) {
            return 0;
        }
        int off = offset;
        int len = length;
        int avail = this.buf.length - this.pos;
        if (avail > 0) {
            if (len < avail) {
                avail = len;
            }
            System.arraycopy(this.buf, this.pos, b, off, avail);
            this.pos += avail;
            off += avail;
            len -= avail;
        }
        if (len > 0) {
            if ((len = this.readable.read(b, off, len)) == -1) {
                return avail == 0 ? -1 : avail;
            }
            return avail + len;
        }
        return avail;
    }

    public void unread(int b) throws IOException {
        this.ensureOpen();
        if (this.pos == 0) {
            throw new IOException("Push back buffer is full");
        }
        this.buf[--this.pos] = (byte)b;
    }

    public void unread(byte[] b, int off, int len) throws IOException {
        this.ensureOpen();
        if (len > this.pos) {
            throw new IOException("Push back buffer is full");
        }
        this.pos -= len;
        System.arraycopy(b, off, this.buf, this.pos, len);
    }

    public void unread(byte[] b) throws IOException {
        this.unread(b, 0, b.length);
    }
}

