/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage.json.osgi;

import com.openexchange.ajax.customizer.file.AdditionalFileField;
import com.openexchange.ajax.requesthandler.ResultConverter;
import com.openexchange.ajax.requesthandler.osgiservice.AJAXModuleActivator;
import com.openexchange.config.ConfigurationService;
import com.openexchange.file.storage.composition.IDBasedFileAccessFactory;
import com.openexchange.file.storage.composition.IDBasedFolderAccessFactory;
import com.openexchange.file.storage.json.FileConverter;
import com.openexchange.file.storage.json.FileMetadataParser;
import com.openexchange.file.storage.json.actions.accounts.AccountActionFactory;
import com.openexchange.file.storage.json.actions.files.AliasFileActionFactory;
import com.openexchange.file.storage.json.actions.files.FileActionFactory;
import com.openexchange.file.storage.json.actions.services.ServiceActionFactory;
import com.openexchange.file.storage.json.osgi.FileFieldCollector;
import com.openexchange.file.storage.json.osgi.I18nServiceCustomizer;
import com.openexchange.file.storage.json.services.Services;
import com.openexchange.file.storage.parse.FileMetadataParserService;
import com.openexchange.file.storage.registry.FileStorageServiceRegistry;
import com.openexchange.folderstorage.FolderService;
import com.openexchange.groupware.attach.AttachmentBase;
import com.openexchange.i18n.I18nService;
import com.openexchange.preview.PreviewService;
import com.openexchange.rdiff.RdiffService;
import com.openexchange.server.ServiceLookup;
import com.openexchange.share.notification.ShareNotificationService;
import com.openexchange.startup.ThreadControlService;
import com.openexchange.threadpool.ThreadPoolService;
import org.osgi.service.event.EventAdmin;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.LoggerFactory;

public class FileStorageJSONActivator
extends AJAXModuleActivator {
    protected Class<?>[] getNeededServices() {
        return new Class[]{FileStorageServiceRegistry.class, IDBasedFileAccessFactory.class, IDBasedFolderAccessFactory.class, AttachmentBase.class, FolderService.class, EventAdmin.class, ConfigurationService.class, ThreadPoolService.class, ThreadControlService.class};
    }

    protected void startBundle() throws Exception {
        try {
            Services.setServiceLookup((ServiceLookup)this);
            this.rememberTracker(new ServiceTracker(this.context, I18nService.class.getName(), (ServiceTrackerCustomizer)new I18nServiceCustomizer(this.context)));
            FileFieldCollector fieldCollector = new FileFieldCollector(this.context);
            Services.setFieldCollector(fieldCollector);
            this.rememberTracker(new ServiceTracker(this.context, AdditionalFileField.class.getName(), (ServiceTrackerCustomizer)fieldCollector));
            this.trackService(ShareNotificationService.class);
            this.trackService(RdiffService.class);
            this.trackService(PreviewService.class);
            this.openTrackers();
            this.registerModule(FileActionFactory.INSTANCE, "infostore");
            this.registerModule(AliasFileActionFactory.ALIAS_INSTANCE, "files");
            this.registerModule(new AccountActionFactory((FileStorageServiceRegistry)this.getService(FileStorageServiceRegistry.class)), "fileaccount");
            this.registerModule(new ServiceActionFactory((FileStorageServiceRegistry)this.getService(FileStorageServiceRegistry.class)), "fileservice");
            this.registerService(FileMetadataParserService.class, FileMetadataParser.getInstance(), null);
            this.registerService(ResultConverter.class, new FileConverter(fieldCollector));
        }
        catch (Exception x) {
            LoggerFactory.getLogger(FileStorageJSONActivator.class).error("", (Throwable)x);
            throw x;
        }
    }

    protected void stopBundle() throws Exception {
        Services.setServiceLookup(null);
        Services.setFieldCollector(null);
        super.stopBundle();
    }
}

