/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage.json.actions.files;

import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.FileStorageFileAccess;
import com.openexchange.file.storage.composition.IDBasedFileAccess;
import com.openexchange.file.storage.json.actions.files.AbstractFileAction;
import com.openexchange.file.storage.json.actions.files.AbstractListingAction;
import com.openexchange.file.storage.json.actions.files.CreatedByComparator;
import com.openexchange.file.storage.json.actions.files.InfostoreRequest;
import com.openexchange.groupware.results.Delta;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.session.ServerSession;
import java.util.ArrayList;
import java.util.List;

@Action(method=RequestMethod.GET, name="updates", description="Get updated infoitems", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module."), @Parameter(name="folder", description="Object ID of the folder, whose contents are queried."), @Parameter(name="columns", description="A comma-separated list of columns to return. Each column is specified by a numeric column identifier. Column identifiers for infoitems are defined in Common object data and Detailed infoitem data."), @Parameter(name="sort", optional=true, description="The identifier of a column which determines the sort order of the response. If this parameter is specified, then the parameter order must be also specified."), @Parameter(name="order", optional=true, description="\"asc\" if the response entires should be sorted in the ascending order, \"desc\" if the response entries should be sorted in the descending order. If this parameter is specified, then the parameter sort must be also specified."), @Parameter(name="timestamp", description="Timestamp of the last update of the requested infoitems."), @Parameter(name="ignore", optional=true, description="Which kinds of updates should be ignored. Currently, the only valid value - \"deleted\" - causes deleted object IDs not to be returned.")}, responseDescription="Response with timestamp: An array with new, modified and deleted infoitems. New and modified infoitems are represented by arrays. The elements of each array contain the information specified by the corresponding identifiers in the columns parameter. Deleted infoitems (should the ignore parameter be ever implemented) would be identified by their object IDs as plain strings, without being part of a nested array.")
public class UpdatesAction
extends AbstractListingAction {
    @Override
    public AJAXRequestResult handle(InfostoreRequest request) throws OXException {
        request.require(AbstractFileAction.Param.FOLDER_ID, AbstractFileAction.Param.COLUMNS);
        IDBasedFileAccess fileAccess = request.getFileAccess();
        long timestamp = request.getTimestamp();
        File.Field sortingField = request.getSortingField();
        FileStorageFileAccess.SortDirection sortingOrder = request.getSortingOrder();
        List<File.Field> columns = request.getFieldsToLoad();
        boolean copy = false;
        if (!columns.contains(File.Field.FOLDER_ID)) {
            columns = new ArrayList<File.Field>(columns);
            columns.add(File.Field.FOLDER_ID);
            copy = true;
        }
        if (!columns.contains(File.Field.ID)) {
            if (!copy) {
                columns = new ArrayList<File.Field>(columns);
                copy = true;
            }
            columns.add(File.Field.ID);
        }
        Delta delta = fileAccess.getDelta(request.getFolderId(), timestamp == -1L ? Long.MIN_VALUE : timestamp, columns, sortingField, sortingOrder, request.getIgnore().contains("deleted"));
        if (File.Field.CREATED_BY.equals((Object)sortingField)) {
            ServerSession serverSession = request.getSession();
            CreatedByComparator comparator = new CreatedByComparator(serverSession.getUser().getLocale(), serverSession.getContext()).setDescending(FileStorageFileAccess.SortDirection.DESC.equals((Object)sortingOrder));
            final SearchIterator<File> iter = CreatedByComparator.resort((SearchIterator<File>)delta.results(), comparator);
            final SearchIterator<File> niter = CreatedByComparator.resort((SearchIterator<File>)delta.getNew(), comparator);
            final SearchIterator<File> miter = CreatedByComparator.resort((SearchIterator<File>)delta.getModified(), comparator);
            final SearchIterator<File> diter = CreatedByComparator.resort((SearchIterator<File>)delta.getDeleted(), comparator);
            final Delta delegate = delta;
            delta = new Delta<File>(){

                public SearchIterator<File> results() throws OXException {
                    return iter;
                }

                public long sequenceNumber() throws OXException {
                    return delegate.sequenceNumber();
                }

                public SearchIterator<File> getNew() {
                    return niter;
                }

                public SearchIterator<File> getModified() {
                    return miter;
                }

                public SearchIterator<File> getDeleted() {
                    return diter;
                }
            };
        }
        return this.result((Delta<File>)delta, request);
    }
}

