/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage.json.actions.files;

import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.FileStorageFileAccess;
import com.openexchange.file.storage.composition.IDBasedFileAccess;
import com.openexchange.file.storage.json.actions.files.AbstractFileAction;
import com.openexchange.file.storage.json.actions.files.AbstractListingAction;
import com.openexchange.file.storage.json.actions.files.CreatedByComparator;
import com.openexchange.file.storage.json.actions.files.InfostoreRequest;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.iterator.SearchIteratorAdapter;
import com.openexchange.tools.session.ServerSession;
import java.util.ArrayList;
import java.util.List;

@Action(method=RequestMethod.PUT, name="search", description="Search infoitems", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module."), @Parameter(name="folder", optional=true, description="The folder ID to restrict the search to. If not specified, all folders are searched."), @Parameter(name="columns", description="The requested fields as per tables Common object data and Detailed infoitem data."), @Parameter(name="sort", optional=true, description="The identifier of a column which determines the sort order of the response. If this parameter is specified, then the parameter order must be also specified."), @Parameter(name="order", optional=true, description="\"asc\" if the response entires should be sorted in the ascending order, \"desc\" if the response entries should be sorted in the descending order. If this parameter is specified, then the parameter sort must be also specified."), @Parameter(name="start", optional=true, description="The start index (inclusive) in the ordered search, that is requested."), @Parameter(name="end", optional=true, description="The last index (inclusive) from the ordered search, that is requested.")}, requestBody="The search pattern string in a JSON object named \"pattern\".", responseDescription="")
public class SearchAction
extends AbstractListingAction {
    @Override
    public AJAXRequestResult handle(InfostoreRequest request) throws OXException {
        request.require(AbstractFileAction.Param.COLUMNS);
        List<File.Field> columns = request.getFieldsToLoad();
        boolean copy = false;
        if (!columns.contains(File.Field.FOLDER_ID)) {
            columns = new ArrayList<File.Field>(columns);
            columns.add(File.Field.FOLDER_ID);
            copy = true;
        }
        if (!columns.contains(File.Field.ID)) {
            if (!copy) {
                columns = new ArrayList<File.Field>(columns);
                copy = true;
            }
            columns.add(File.Field.ID);
        }
        File.Field sortingField = request.getSortingField();
        FileStorageFileAccess.SortDirection sortingOrder = request.getSortingOrder();
        IDBasedFileAccess fileAccess = request.getFileAccess();
        SearchIteratorAdapter results = fileAccess.search(request.getSearchQuery(), columns, request.getSearchFolderId(), sortingField, sortingOrder, request.getStart(), request.getEnd());
        if (File.Field.CREATED_BY.equals((Object)sortingField)) {
            ServerSession serverSession = request.getSession();
            CreatedByComparator comparator = new CreatedByComparator(serverSession.getUser().getLocale(), serverSession.getContext()).setDescending(FileStorageFileAccess.SortDirection.DESC.equals((Object)sortingOrder));
            results = CreatedByComparator.resort((SearchIterator<File>)results, comparator);
        }
        int limit = 0;
        if (request.getStart() == 0 && request.getEnd() != 0) {
            limit = request.getEnd() - request.getStart() + 1;
        }
        if (limit != 0 && results.size() > limit) {
            ArrayList<Object> resultList = new ArrayList<Object>(limit);
            for (int x = 0; x < limit && results.hasNext(); ++x) {
                resultList.add(results.next());
            }
            results = new SearchIteratorAdapter(resultList.iterator());
        }
        return this.results((SearchIterator<File>)results, 0L, request);
    }
}

