/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage.json.actions.files;

import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.AbstractFileFieldHandler;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.FileFieldHandler;
import com.openexchange.file.storage.FileFieldSwitcher;
import com.openexchange.file.storage.FileStorageFileAccess;
import com.openexchange.file.storage.composition.IDBasedFileAccess;
import com.openexchange.file.storage.json.actions.files.AbstractFileAction;
import com.openexchange.file.storage.json.actions.files.AbstractWriteAction;
import com.openexchange.file.storage.json.actions.files.InfostoreRequest;
import com.openexchange.file.storage.meta.FileFieldSet;
import com.openexchange.groupware.attach.AttachmentBase;
import com.openexchange.groupware.attach.AttachmentField;
import com.openexchange.groupware.attach.AttachmentMetadata;
import com.openexchange.groupware.attach.util.GetSwitch;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.java.Streams;
import com.openexchange.session.Session;
import com.openexchange.tools.session.ServerSession;
import java.io.Closeable;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

@Action(method=RequestMethod.PUT, name="saveAs", description="Save an attachment in the infostore", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module."), @Parameter(name="attached", description="The Object ID of the Object with the attachment."), @Parameter(name="folder", description="The Folder ID of the Object with the attachment."), @Parameter(name="module", description="the Module type of the Object with the attachment."), @Parameter(name="Attachment", description="The id of the attachement to save.")}, requestBody="Infoitem object as described in Common object data and Detailed infoitem data. The field id is not included. The fields in this infoitem object override values from the attachment. The folder_id must be given.", responseDescription="Object ID of the newly created infoitem.")
public class SaveAsAction
extends AbstractWriteAction {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AJAXRequestResult handle(InfostoreRequest request) throws OXException {
        request.require(AbstractFileAction.Param.FOLDER_ID, AbstractFileAction.Param.ATTACHED_ID, AbstractFileAction.Param.MODULE, AbstractFileAction.Param.ATTACHMENT).requireFileMetadata();
        int folderId = Integer.parseInt(request.getFolderId());
        int attachedId = request.getAttachedId();
        int moduleId = request.getModule();
        int attachment = request.getAttachment();
        final File file = request.getFile();
        final List<File.Field> sentColumns = request.getSentColumns();
        AttachmentBase attachments = request.getAttachmentBase();
        IDBasedFileAccess fileAccess = request.getFileAccess();
        ServerSession session = request.getSession();
        User user = session.getUser();
        UserConfiguration userConfiguration = session.getUserConfiguration();
        AttachmentMetadata att = attachments.getAttachment((Session)session, folderId, attachedId, moduleId, attachment, session.getContext(), user, userConfiguration);
        final FileFieldSet fileSet = new FileFieldSet();
        final GetSwitch attGet = new GetSwitch(att);
        File.Field.forAllFields((FileFieldHandler)new AbstractFileFieldHandler(){

            public Object handle(File.Field field, Object ... args) {
                if (sentColumns.contains(field)) {
                    return null;
                }
                AttachmentField matchingAttachmentField = SaveAsAction.this.getMatchingAttachmentField(field);
                if (matchingAttachmentField == null) {
                    return null;
                }
                Object value = matchingAttachmentField.doSwitch((AttachmentField.AttachmentSwitch)attGet);
                field.doSwitch((FileFieldSwitcher)fileSet, new Object[]{file, value});
                return null;
            }
        }, (Object[])new Object[0]);
        file.setId(FileStorageFileAccess.NEW);
        InputStream fileData = attachments.getAttachedFile((Session)session, folderId, attachedId, moduleId, attachment, session.getContext(), user, userConfiguration);
        try {
            ArrayList<File.Field> modifiedColumns = null != sentColumns ? new ArrayList<File.Field>(sentColumns) : new ArrayList();
            modifiedColumns.add(File.Field.FILENAME);
            modifiedColumns.add(File.Field.FILE_SIZE);
            modifiedColumns.add(File.Field.FILE_MIMETYPE);
            modifiedColumns.add(File.Field.TITLE);
            modifiedColumns.add(File.Field.DESCRIPTION);
            String newID = fileAccess.saveDocument(file, fileData, -1L, modifiedColumns, false, true, false);
            AJAXRequestResult result = new AJAXRequestResult((Object)newID, new Date(file.getSequenceNumber()));
            List warnings = fileAccess.getAndFlushWarnings();
            if (null != warnings && 0 < warnings.size()) {
                result.addWarnings((Collection)warnings);
            }
            AJAXRequestResult aJAXRequestResult = result;
            return aJAXRequestResult;
        }
        finally {
            Streams.close((Closeable)fileData);
        }
    }

    protected AttachmentField getMatchingAttachmentField(File.Field fileField) {
        switch (fileField) {
            case FILENAME: {
                return AttachmentField.FILENAME_LITERAL;
            }
            case FILE_SIZE: {
                return AttachmentField.FILE_SIZE_LITERAL;
            }
            case FILE_MIMETYPE: {
                return AttachmentField.FILE_MIMETYPE_LITERAL;
            }
            case TITLE: {
                return AttachmentField.FILENAME_LITERAL;
            }
            case DESCRIPTION: {
                return AttachmentField.COMMENT_LITERAL;
            }
        }
        return null;
    }
}

