/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage.json.actions.files;

import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.FileStorageFileAccess;
import com.openexchange.file.storage.composition.IDBasedFileAccess;
import com.openexchange.file.storage.json.actions.files.AbstractFileAction;
import com.openexchange.file.storage.json.actions.files.AbstractWriteAction;
import com.openexchange.file.storage.json.actions.files.InfostoreRequest;
import com.openexchange.groupware.results.TimedResult;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.iterator.SearchIterators;
import java.util.ArrayList;

@Action(method=RequestMethod.PUT, name="revert", description="Delete all versions of infostore documents", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module."), @Parameter(name="id", description="The ID of the base Object."), @Parameter(name="folder", description="The Folder of the Object."), @Parameter(name="timestamp", description="Timestamp of the infostore object.")}, requestBody="", responseDescription="")
public class RevertAction
extends AbstractWriteAction {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AJAXRequestResult handle(InfostoreRequest request) throws OXException {
        request.require(AbstractFileAction.Param.ID);
        IDBasedFileAccess fileAccess = request.getFileAccess();
        TimedResult versions = fileAccess.getVersions(request.getId());
        ArrayList<String> versionIdentifiers = new ArrayList<String>(10);
        SearchIterator results = versions.results();
        try {
            while (results.hasNext()) {
                String version = ((File)results.next()).getVersion();
                if (version == null || version.equals("0")) continue;
                versionIdentifiers.add(version);
            }
            String[] toDelete = new String[versionIdentifiers.size()];
            for (int i = 0; i < toDelete.length; ++i) {
                toDelete[i] = (String)versionIdentifiers.get(i);
            }
            fileAccess.removeVersion(request.getId(), toDelete);
            File fileMetadata = fileAccess.getFileMetadata(request.getId(), FileStorageFileAccess.CURRENT_VERSION);
            AJAXRequestResult aJAXRequestResult = this.success(fileMetadata.getSequenceNumber());
            return aJAXRequestResult;
        }
        finally {
            SearchIterators.close((SearchIterator)results);
        }
    }
}

