/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage.json.actions.files;

import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.FileStorageObjectPermission;
import com.openexchange.file.storage.composition.IDBasedFileAccess;
import com.openexchange.file.storage.json.actions.files.AbstractFileAction;
import com.openexchange.file.storage.json.actions.files.AbstractWriteAction;
import com.openexchange.file.storage.json.actions.files.InfostoreRequest;
import com.openexchange.file.storage.json.services.Services;
import com.openexchange.server.ServiceExceptionCode;
import com.openexchange.session.Session;
import com.openexchange.share.ShareTargetPath;
import com.openexchange.share.notification.Entities;
import com.openexchange.share.notification.ShareNotificationService;
import java.util.Collection;
import java.util.List;
import org.json.JSONObject;

public class NotifyAction
extends AbstractWriteAction {
    @Override
    public AJAXRequestResult handle(InfostoreRequest request) throws OXException {
        request.require(AbstractFileAction.Param.ID);
        IDBasedFileAccess fileAccess = request.getFileAccess();
        File metadata = fileAccess.getFileMetadata(request.getId(), request.getVersion());
        Entities entities = NotifyAction.filterEntities(request.getEntities(), metadata.getObjectPermissions());
        ShareNotificationService.Transport transport = request.getNotificationTransport();
        if (null == transport) {
            transport = ShareNotificationService.Transport.MAIL;
        }
        String message = request.getNotifiactionMessage();
        ShareNotificationService notificationService = Services.getShareNotificationService();
        if (null == notificationService) {
            throw ServiceExceptionCode.absentService(ShareNotificationService.class);
        }
        ShareTargetPath targetPath = new ShareTargetPath(8, metadata.getFolderId(), metadata.getId());
        List warnings = notificationService.sendShareNotifications(transport, entities, message, targetPath, (Session)request.getSession(), request.getRequestData().getHostData());
        AJAXRequestResult result = new AJAXRequestResult((Object)new JSONObject(), "json");
        result.addWarnings((Collection)warnings);
        return result;
    }

    private static Entities filterEntities(List<Integer> entityIDs, List<FileStorageObjectPermission> permissions) throws OXException {
        Entities entities = new Entities();
        for (Integer entityID : entityIDs) {
            FileStorageObjectPermission matchingPermission = null;
            if (null != permissions) {
                for (FileStorageObjectPermission permission : permissions) {
                    if (permission.getEntity() != entityID.intValue()) continue;
                    matchingPermission = permission;
                    break;
                }
            }
            if (null == matchingPermission) {
                throw OXException.notFound((String)entityID.toString());
            }
            if (matchingPermission.isGroup()) {
                entities.addGroup(matchingPermission.getEntity(), Entities.PermissionType.OBJECT, matchingPermission.getPermissions());
                continue;
            }
            entities.addUser(matchingPermission.getEntity(), Entities.PermissionType.OBJECT, matchingPermission.getPermissions());
        }
        return entities;
    }
}

