/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage.json.actions.files;

import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.composition.FileID;
import com.openexchange.file.storage.composition.IDBasedFileAccess;
import com.openexchange.file.storage.json.actions.files.AbstractListingAction;
import com.openexchange.file.storage.json.actions.files.InfostoreRequest;
import com.openexchange.groupware.results.FilteringTimedResult;
import com.openexchange.groupware.results.TimedResult;
import java.util.ArrayList;
import java.util.List;

@Action(method=RequestMethod.PUT, name="list", description="Get a list of infoitems", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module."), @Parameter(name="columns", description="A comma-separated list of columns to return. Each column is specified by a numeric column identifier. Column identifiers for infoitems are defined in Common object data and Detailed infoitem data.")}, requestBody="An array with object IDs of requested infoitems. ", responseDescription="Response with timestamp: An array with infoitem data. Each array element describes one infoitem and is itself an array. The elements of each array contain the information specified by the corresponding identifiers in the columns parameter.")
public class ListAction
extends AbstractListingAction {
    @Override
    public AJAXRequestResult handle(final InfostoreRequest request) throws OXException {
        request.requireBody();
        IDBasedFileAccess fileAccess = request.getFileAccess();
        List<File.Field> columns = request.getFieldsToLoad();
        boolean copy = false;
        if (!columns.contains(File.Field.FOLDER_ID)) {
            columns = new ArrayList<File.Field>(columns);
            columns.add(File.Field.FOLDER_ID);
            copy = true;
        }
        if (!columns.contains(File.Field.ID)) {
            if (!copy) {
                columns = new ArrayList<File.Field>(columns);
                copy = true;
            }
            columns.add(File.Field.ID);
        }
        final List<String> ids = request.getIds();
        FilteringTimedResult<File> documents = new FilteringTimedResult<File>(fileAccess.getDocuments(ids, columns)){
            private int threshhold;
            {
                super(x0);
                this.threshhold = 0;
            }

            protected boolean accept(File thing) throws OXException {
                String folderForID;
                int i;
                for (i = this.threshhold; i < ids.size(); ++i) {
                    FileID fileID = new FileID((String)ids.get(i));
                    if (!fileID.toUniqueID().equals(thing.getId())) continue;
                    this.threshhold = i + 1;
                    break;
                }
                return null != (folderForID = request.getFolderAt(i)) && folderForID.equals(thing.getFolderId());
            }
        };
        return this.result((TimedResult<File>)documents, request);
    }
}

