/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage.json.actions.files;

import com.openexchange.ajax.container.TmpFileFileHolder;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.requesthandler.DispatcherNotes;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.composition.IDBasedFileAccess;
import com.openexchange.file.storage.json.actions.files.AbstractFileAction;
import com.openexchange.file.storage.json.actions.files.InfostoreRequest;
import com.openexchange.file.storage.json.services.Services;
import com.openexchange.java.Streams;
import com.openexchange.rdiff.RdiffService;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import java.io.Closeable;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

@DispatcherNotes(defaultFormat="file")
public class DocumentSigAction
extends AbstractFileAction {
    @Override
    public AJAXRequestResult handle(InfostoreRequest request) throws OXException {
        AJAXRequestResult aJAXRequestResult;
        request.require(AbstractFileAction.Param.ID);
        IDBasedFileAccess fileAccess = request.getFileAccess();
        InputStream documentStream = null;
        FileOutputStream sigOut = null;
        try {
            RdiffService rdiff = Services.getRdiffService();
            documentStream = fileAccess.getDocument(request.getId(), request.getVersion());
            TmpFileFileHolder fileHolder = new TmpFileFileHolder();
            sigOut = new FileOutputStream(fileHolder.getTmpFile());
            rdiff.createSignatures(documentStream, (OutputStream)sigOut);
            sigOut.flush();
            aJAXRequestResult = new AJAXRequestResult((Object)fileHolder, "file");
        }
        catch (IOException e) {
            try {
                throw AjaxExceptionCodes.IO_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
            }
            catch (Throwable throwable) {
                Streams.close((Closeable[])new Closeable[]{documentStream, sigOut});
                throw throwable;
            }
        }
        Streams.close((Closeable[])new Closeable[]{documentStream, sigOut});
        return aJAXRequestResult;
    }
}

