/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage.json.actions.files;

import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.configuration.ServerConfig;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.composition.IDBasedFileAccess;
import com.openexchange.file.storage.json.actions.files.AbstractFileAction;
import com.openexchange.file.storage.json.actions.files.InfostoreRequest;
import com.openexchange.file.storage.json.services.Services;
import com.openexchange.java.Streams;
import com.openexchange.rdiff.RdiffService;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONObject;

public class DocumentPatchAction
extends AbstractFileAction {
    @Override
    public AJAXRequestResult handle(InfostoreRequest request) throws OXException {
        AJAXRequestResult aJAXRequestResult;
        request.require(AbstractFileAction.Param.ID);
        IDBasedFileAccess fileAccess = request.getFileAccess();
        ArrayList<Closeable> closeables = new ArrayList<Closeable>(4);
        File baseFile = null;
        File patchedFile = null;
        try {
            int read;
            int buflen = 8192;
            baseFile = DocumentPatchAction.newTempFile();
            InputStream documentStream = DocumentPatchAction.gen(fileAccess.getDocument(request.getId(), request.getVersion()), closeables);
            OutputStream baseOut = DocumentPatchAction.gen(new FileOutputStream(baseFile), closeables);
            byte[] buf = new byte[8192];
            while ((read = documentStream.read(buf, 0, 8192)) > 0) {
                baseOut.write(buf, 0, read);
            }
            baseOut.flush();
            DocumentPatchAction.dropFirstFrom(closeables);
            DocumentPatchAction.dropFirstFrom(closeables);
            patchedFile = DocumentPatchAction.newTempFile();
            OutputStream patchOut = DocumentPatchAction.gen(new FileOutputStream(patchedFile), closeables);
            InputStream requestStream = DocumentPatchAction.gen(request.getUploadStream(), closeables);
            RdiffService rdiff = Services.getRdiffService();
            rdiff.rebuildFile(baseFile, requestStream, patchOut);
            patchOut.flush();
            DocumentPatchAction.dropFirstFrom(closeables);
            DocumentPatchAction.dropFirstFrom(closeables);
            InputStream patchedIn = DocumentPatchAction.gen(new FileInputStream(patchedFile), closeables);
            fileAccess.saveDocument(fileAccess.getFileMetadata(request.getId(), request.getVersion()), patchedIn, -1L);
            aJAXRequestResult = new AJAXRequestResult(JSONObject.NULL, "json");
        }
        catch (IOException e) {
            try {
                throw AjaxExceptionCodes.IO_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
            }
            catch (Throwable throwable) {
                while (!closeables.isEmpty()) {
                    Streams.close((Closeable)((Closeable)closeables.remove(0)));
                }
                DocumentPatchAction.delete(baseFile);
                DocumentPatchAction.delete(patchedFile);
                throw throwable;
            }
        }
        while (!closeables.isEmpty()) {
            Streams.close((Closeable)((Closeable)closeables.remove(0)));
        }
        DocumentPatchAction.delete(baseFile);
        DocumentPatchAction.delete(patchedFile);
        return aJAXRequestResult;
    }

    private static <C extends Closeable> C gen(C newInstance, List<Closeable> col) {
        col.add(newInstance);
        return newInstance;
    }

    private static void dropFirstFrom(List<Closeable> col) {
        Streams.close((Closeable)col.remove(0));
    }

    private static void delete(File file) {
        if (null != file) {
            try {
                file.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static File newTempFile() throws OXException {
        try {
            File directory = new File(ServerConfig.getProperty((ServerConfig.Property)ServerConfig.Property.UploadDirectory));
            File tmpFile = File.createTempFile("open-xchange-dpa-", ".tmp", directory);
            tmpFile.deleteOnExit();
            return tmpFile;
        }
        catch (IOException e) {
            throw AjaxExceptionCodes.IO_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
        catch (RuntimeException e) {
            throw AjaxExceptionCodes.UNEXPECTED_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
    }
}

