/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage.json.actions.files;

import com.openexchange.ajax.container.TmpFileFileHolder;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.composition.IDBasedFileAccess;
import com.openexchange.file.storage.json.actions.files.AbstractFileAction;
import com.openexchange.file.storage.json.actions.files.InfostoreRequest;
import com.openexchange.file.storage.json.services.Services;
import com.openexchange.java.Streams;
import com.openexchange.rdiff.RdiffService;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import java.io.Closeable;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

public class DocumentDeltaAction
extends AbstractFileAction {
    @Override
    public AJAXRequestResult handle(InfostoreRequest request) throws OXException {
        AJAXRequestResult aJAXRequestResult;
        request.require(AbstractFileAction.Param.ID);
        IDBasedFileAccess fileAccess = request.getFileAccess();
        InputStream documentStream = null;
        InputStream requestStream = null;
        FileOutputStream deltaOut = null;
        try {
            RdiffService rdiff = Services.getRdiffService();
            documentStream = fileAccess.getDocument(request.getId(), request.getVersion());
            requestStream = request.getUploadStream();
            List signatures = rdiff.readSignatures(requestStream);
            TmpFileFileHolder fileHolder = new TmpFileFileHolder();
            deltaOut = new FileOutputStream(fileHolder.getTmpFile());
            rdiff.createDeltas(signatures, documentStream, (OutputStream)deltaOut);
            deltaOut.flush();
            aJAXRequestResult = new AJAXRequestResult((Object)fileHolder, "file");
        }
        catch (IOException e) {
            try {
                throw AjaxExceptionCodes.IO_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
            }
            catch (Throwable throwable) {
                Streams.close((Closeable[])new Closeable[]{documentStream, requestStream, deltaOut});
                throw throwable;
            }
        }
        Streams.close((Closeable[])new Closeable[]{documentStream, requestStream, deltaOut});
        return aJAXRequestResult;
    }
}

